/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class RateEpochBranchRateModel
extends AbstractBranchRateModel {
    protected final Parameter[] timeParameters;
    protected final Parameter[] rateParameters;

    public RateEpochBranchRateModel(Parameter[] parameterArray, Parameter[] parameterArray2) {
        super("rateEpochBranchRates");
        this.timeParameters = parameterArray;
        for (Parameter parameter : parameterArray) {
            this.addVariable(parameter);
        }
        this.rateParameters = parameterArray2;
        for (Parameter parameter : parameterArray2) {
            this.addVariable(parameter);
        }
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null) {
            int n;
            double d = tree.getNodeHeight(nodeRef);
            double d2 = tree.getNodeHeight(nodeRef2);
            double d3 = 0.0;
            double d4 = d;
            for (n = 0; n < this.timeParameters.length && d > this.timeParameters[n].getParameterValue(0); ++n) {
            }
            while (n < this.timeParameters.length && d2 > this.timeParameters[n].getParameterValue(0)) {
                d3 += this.rateParameters[n].getParameterValue(0) * (this.timeParameters[n].getParameterValue(0) - d4);
                d4 = this.timeParameters[n].getParameterValue(0);
                ++n;
            }
            return this.normalizeRate((d3 += this.rateParameters[n].getParameterValue(0) * (d2 - d4)) / (d2 - d));
        }
        throw new IllegalArgumentException("root node doesn't have a rate!");
    }

    protected double normalizeRate(double d) {
        return d;
    }
}

