/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.math.MathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class GMRFBivariateCurveAnalysis {
    private LogFileTraces[] lft;
    private double endTime;
    private final int[] defaultIntegrationPartitionSizes = new int[]{2, 5, 10, 15, 25, 50, 100, 1000, 5000, 25000};
    private final int[] defaultDensityPartitionSizes = new int[]{10};

    public GMRFBivariateCurveAnalysis(String[] stringArray, double d, int n) throws TraceException, IOException {
        this.endTime = d;
        this.lft = new LogFileTraces[2];
        for (int i = 0; i < 2; ++i) {
            File file = new File(stringArray[i]);
            this.lft[i] = new LogFileTraces(stringArray[i], file);
            this.lft[i].loadTraces();
            this.lft[i].setBurnIn(n);
        }
    }

    public void densityReport() {
        for (int n : this.defaultDensityPartitionSizes) {
            this.densityReport(n);
        }
    }

    private void densityReport(int n) {
        double[][] dArrayArray = new double[][]{new double[this.lft[0].getTraceCount()], new double[this.lft[1].getTraceCount()]};
        ArrayList<DensityResult> arrayList = new ArrayList<DensityResult>(this.lft[0].getStateCount());
        for (int i = 0; i < this.lft[0].getStateCount(); ++i) {
            this.lft[0].getStateValues(i, dArrayArray[0], 0);
            this.lft[1].getStateValues(i, dArrayArray[1], 0);
            arrayList.add(new DensityResult(this.getDensityReport(dArrayArray, n)));
        }
        Collections.sort(arrayList);
        double d = Math.sqrt(arrayList.size());
        int n2 = (int)Math.floor(d);
        double d2 = ((DensityResult)arrayList.get((int)n2)).radius;
        double d3 = MathUtils.logHyperSphereVolume(n, d2);
        System.out.println("Approximate Density at 0 with " + n + " partitions = " + 1.0 / (d * Math.exp(d3)));
    }

    private double[] getDensityReport(double[][] dArray, int n) {
        double[] dArray2 = new double[n];
        double d = this.endTime / (double)n;
        double d2 = d / 2.0;
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray3 = new double[]{this.getPopSizeAtTime(dArray[0], d2, dArray[0].length / 2), this.getPopSizeAtTime(dArray[1], d2, dArray[1].length / 2)};
            d2 += d;
            dArray2[i] = dArray3[0] - dArray3[1];
        }
        return dArray2;
    }

    public void integrationReport() {
        System.out.println("Analyzing Difference Between Curves\n");
        for (int n : this.defaultIntegrationPartitionSizes) {
            this.integrationReport(n);
        }
    }

    private void integrationReport(int n) {
        double[] dArray = new double[this.lft[0].getStateCount()];
        double[][] dArrayArray = new double[][]{new double[this.lft[0].getTraceCount()], new double[this.lft[1].getTraceCount()]};
        double d = this.endTime / (double)(n * 2);
        double d2 = this.endTime / (double)n;
        for (int i = 0; i < this.lft[0].getStateCount(); ++i) {
            this.lft[0].getStateValues(i, dArrayArray[0], 0);
            this.lft[1].getStateValues(i, dArrayArray[1], 0);
            dArray[i] = this.getPartitionReport(dArrayArray, d, d2);
        }
        double d3 = 0.0;
        for (double d4 : dArray) {
            d3 += d4;
        }
        System.out.println("Partition Size " + n + " = " + d3 / (double)dArray.length);
    }

    private double getPartitionReport(double[][] dArray, double d, double d2) {
        double d3 = 0.0;
        while (d < this.endTime) {
            d3 += this.getPopSizeDifference(dArray, d);
            d += d2;
        }
        return d3 *= d2;
    }

    private double getPopSizeDifference(double[][] dArray, double d) {
        double[] dArray2 = new double[2];
        for (int i = 0; i < 2; ++i) {
            dArray2[i] = this.getPopSizeAtTime(dArray[i], d, dArray[i].length / 2);
        }
        return Math.abs(dArray2[0] - dArray2[1]);
    }

    private double getPopSizeAtTime(double[] dArray, double d, int n) {
        for (int i = 0; i < n; ++i) {
            if (!(d < dArray[i])) continue;
            return dArray[n + i];
        }
        return -99.0;
    }

    private class DensityResult
    implements Comparable<DensityResult> {
        public double[] results;
        public double radius;

        public DensityResult(double[] dArray) {
            this.results = dArray;
            double d = 0.0;
            for (double d2 : dArray) {
                d += d2 * d2;
            }
            this.radius = Math.pow(d, 1.0 / (double)dArray.length);
        }

        @Override
        public int compareTo(DensityResult densityResult) {
            if (this.radius < densityResult.radius) {
                return -1;
            }
            if (this.radius == densityResult.radius) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            String string = "(";
            for (double d : this.results) {
                string = string + Double.toString(d) + ", ";
            }
            string = string + " Radius = " + this.radius + " )\n";
            return string;
        }
    }
}

