/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PopSizeStatistic
extends Statistic.Abstract {
    public static final String POPSIZE_STATISTIC = "popSizeStatistic";
    public DemographicModel model;
    public double time;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DemographicModel.class), new StringAttributeRule("name", "A name for this statistic primarily for the purposes of logging", true), AttributeRule.newDoubleRule("time", false)};

        @Override
        public String getParserName() {
            return PopSizeStatistic.POPSIZE_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getAttribute("name", xMLObject.getId());
            DemographicModel demographicModel = (DemographicModel)xMLObject.getChild(DemographicModel.class);
            double d = xMLObject.getDoubleAttribute("time");
            return new PopSizeStatistic(string, demographicModel, d);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that has as its value the height of the most recent common ancestor of a set of taxa in a given tree";
        }

        @Override
        public Class getReturnType() {
            return PopSizeStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public PopSizeStatistic(String string, DemographicModel demographicModel, double d) {
        super(string);
        this.model = demographicModel;
        this.time = d;
    }

    @Override
    public int getDimension() {
        return 2 + this.model.getVariableCount();
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            return this.model.getDemographicFunction().getDemographic(this.time);
        }
        if (n == 1) {
            return this.model.getDemographicFunction().getIntensity(this.time);
        }
        return (Double)this.model.getVariable(n - 2).getValue(0);
    }
}

