/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.EmpiricalPiecewiseConstant;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;

public class EmpiricalPiecewiseModel
extends DemographicModel {
    Parameter tauParameter;
    Parameter lagParameter;
    Parameter bParameter;
    Parameter populationSizesParameter;
    double[] intervalWidths;
    EmpiricalPiecewiseConstant piecewiseFunction = null;

    public EmpiricalPiecewiseModel(double[] dArray, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this("empiricalPiecewise", dArray, parameter, parameter2, parameter3, parameter4, type);
    }

    public EmpiricalPiecewiseModel(String string, double[] dArray, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        super(string);
        if (dArray.length == 1) {
            double[] dArray2 = new double[parameter.getDimension() - 1];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[0];
            }
            dArray = dArray2;
        }
        if (parameter.getDimension() != dArray.length + 1) {
            throw new IllegalArgumentException("interval widths array must have either 1 or " + (parameter.getDimension() - 1) + " elements, but instead it has " + dArray.length + ".");
        }
        this.tauParameter = parameter2;
        this.lagParameter = parameter4;
        this.bParameter = parameter3;
        this.intervalWidths = dArray;
        this.populationSizesParameter = parameter;
        this.addVariable(parameter2);
        this.addVariable(parameter4);
        this.addVariable(parameter3);
        this.addVariable(parameter);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, parameter2.getDimension()));
        parameter4.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, parameter4.getDimension()));
        parameter3.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, parameter3.getDimension()));
        parameter.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, parameter.getDimension()));
        this.setUnits(type);
        this.piecewiseFunction = new EmpiricalPiecewiseConstant(dArray, this.calculatePopSizes(), parameter4.getParameterValue(0), type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.piecewiseFunction.setLag(this.lagParameter.getParameterValue(0));
        this.piecewiseFunction.setPopulationSizes(this.calculatePopSizes());
        return this.piecewiseFunction;
    }

    private double[] calculatePopSizes() {
        double d = this.tauParameter.getParameterValue(0);
        double d2 = this.bParameter.getParameterValue(0);
        double[] dArray = new double[this.populationSizesParameter.getDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d * this.populationSizesParameter.getParameterValue(i) + d2;
        }
        return dArray;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

