/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialExponential;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;

public class ExponentialExponentialModel
extends DemographicModel {
    private final Parameter N0Parameter;
    private final Parameter N1Parameter;
    private final Parameter growthRateParameter;
    private final Parameter ancestralGrowthRateParameter;
    private final Parameter transitionTimeParameter;
    private final ExponentialExponential exponentialExponential;

    public ExponentialExponentialModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this("exponentialExponential", parameter, null, parameter2, parameter3, parameter4, type);
    }

    public ExponentialExponentialModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Units.Type type) {
        this("exponentialExponential", parameter, parameter2, parameter3, parameter4, parameter5, type);
    }

    public ExponentialExponentialModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Units.Type type) {
        super(string);
        this.exponentialExponential = new ExponentialExponential(type);
        this.N0Parameter = parameter;
        this.N1Parameter = parameter2;
        if (parameter != null) {
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (parameter2 != null) {
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.ancestralGrowthRateParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.transitionTimeParameter = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addStatistic(new N0Statistic());
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.exponentialExponential.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        this.exponentialExponential.setAncestralGrowthRate(this.ancestralGrowthRateParameter.getParameterValue(0));
        this.exponentialExponential.setTransitionTime(this.transitionTimeParameter.getParameterValue(0) - this.getTimeOffset());
        if (this.N0Parameter != null) {
            this.exponentialExponential.setN0(this.N0Parameter.getParameterValue(0));
        } else {
            this.exponentialExponential.setN1(this.N1Parameter.getParameterValue(0));
        }
        return this.exponentialExponential;
    }

    public class N0Statistic
    extends Statistic.Abstract {
        public N0Statistic() {
            super("N0");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return ExponentialExponentialModel.this.exponentialExponential.getN0();
        }
    }
}

