/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeStatistic;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.Statistic;
import dr.stats.DiscreteStatistics;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class DiffusionRateCovarianceStatistic
extends Statistic.Abstract {
    public static final String DIFFUSION_RATE_COVARIANCE_STATISTIC = "diffusionRateCovarianceStatistic";
    public static final String TREE_DISPERSION_COVARIANCE_STATISTIC = "treeDispersionCovarianceStatistic";
    public static final String BOOLEAN_DIS_OPTION = "greatCircleDistance";
    public static final String BOOLEAN_DC_OPTION = "diffusionCoefficient";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("name", true), AttributeRule.newBooleanRule("greatCircleDistance", true), AttributeRule.newBooleanRule("diffusionCoefficient", true), new ElementRule(MutableTreeModel.class), new ElementRule(AbstractMultivariateTraitLikelihood.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return DiffusionRateCovarianceStatistic.DIFFUSION_RATE_COVARIANCE_STATISTIC;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{this.getParserName(), DiffusionRateCovarianceStatistic.TREE_DISPERSION_COVARIANCE_STATISTIC};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getAttribute("name", xMLObject.getId());
            TreeModel treeModel = (TreeModel)xMLObject.getChild(Tree.class);
            boolean bl = xMLObject.getAttribute(DiffusionRateCovarianceStatistic.BOOLEAN_DIS_OPTION, false);
            boolean bl2 = xMLObject.getAttribute(DiffusionRateCovarianceStatistic.BOOLEAN_DC_OPTION, false);
            ArrayList<AbstractMultivariateTraitLikelihood> arrayList = new ArrayList<AbstractMultivariateTraitLikelihood>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof AbstractMultivariateTraitLikelihood)) continue;
                arrayList.add((AbstractMultivariateTraitLikelihood)xMLObject.getChild(i));
            }
            return new DiffusionRateCovarianceStatistic(string, treeModel, arrayList, bl, bl2);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that returns the average of the branch rates";
        }

        @Override
        public Class getReturnType() {
            return TreeStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean useGreatCircleDistances;
    private List<AbstractMultivariateTraitLikelihood> traitLikelihoods;
    private double[] childRate = null;
    private double[] parentRate = null;
    private boolean diffusionCoefficient;

    public DiffusionRateCovarianceStatistic(String string, TreeModel treeModel, List<AbstractMultivariateTraitLikelihood> list, boolean bl, boolean bl2) {
        super(string);
        this.traitLikelihoods = list;
        this.useGreatCircleDistances = bl;
        this.diffusionCoefficient = bl2;
        int n = treeModel.getExternalNodeCount();
        this.childRate = new double[2 * n - 4];
        this.parentRate = new double[this.childRate.length];
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        String string = this.traitLikelihoods.get(0).getTraitName();
        for (AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood : this.traitLikelihoods) {
            MutableTreeModel mutableTreeModel = abstractMultivariateTraitLikelihood.getTreeModel();
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < mutableTreeModel.getNodeCount(); ++i) {
                double d;
                NodeRef nodeRef = mutableTreeModel.getNode(i);
                NodeRef nodeRef2 = mutableTreeModel.getParent(nodeRef);
                if (!(nodeRef2 != null & !mutableTreeModel.isRoot(nodeRef2))) continue;
                double[] dArray = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef, string);
                double[] dArray2 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef2, string);
                double d2 = mutableTreeModel.getBranchLength(nodeRef);
                double d3 = mutableTreeModel.getBranchLength(nodeRef2);
                NodeRef nodeRef3 = mutableTreeModel.getParent(nodeRef2);
                double[] dArray3 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef3, string);
                if (this.useGreatCircleDistances && dArray.length == 2) {
                    SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(dArray[0], dArray[1]);
                    SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(dArray2[0], dArray2[1]);
                    d = sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
                    SphericalPolarCoordinates sphericalPolarCoordinates3 = new SphericalPolarCoordinates(dArray3[0], dArray3[1]);
                    double d4 = sphericalPolarCoordinates2.distance(sphericalPolarCoordinates3);
                    if (!this.diffusionCoefficient) {
                        this.childRate[n2] = d / d2;
                        this.parentRate[n2] = d4 / d3;
                    } else {
                        this.childRate[n2] = Math.pow(d, 2.0) / (4.0 * d2);
                        this.parentRate[n2] = Math.pow(d4, 2.0) / (4.0 * d3);
                    }
                } else {
                    double d5 = this.getNativeDistance(dArray, dArray2);
                    d = this.getNativeDistance(dArray2, dArray3);
                    if (!this.diffusionCoefficient) {
                        this.childRate[n2] = d5 / d2;
                        this.parentRate[n2] = d / d3;
                    } else {
                        this.childRate[n2] = Math.pow(d5, 2.0) / (4.0 * d2);
                        this.parentRate[n2] = Math.pow(d, 2.0) / (4.0 * d3);
                    }
                }
                ++n2;
            }
        }
        return DiscreteStatistics.covariance(this.childRate, this.parentRate);
    }

    private double getNativeDistance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.pow(dArray2[i] - dArray[i], 2.0);
        }
        return Math.sqrt(d);
    }
}

