/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.CompoundParameter;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;

public class IntegratedProcessTraitDataModel
extends ContinuousTraitDataModel
implements ContinuousTraitPartialsProvider {
    public IntegratedProcessTraitDataModel(String string, CompoundParameter compoundParameter, boolean[] blArray, boolean bl, int n) {
        super(string, compoundParameter, blArray, bl, n, PrecisionType.FULL);
    }

    public IntegratedProcessTraitDataModel(String string, CompoundParameter compoundParameter, boolean[] blArray, boolean bl, int n, PrecisionType precisionType) {
        this(string, compoundParameter, blArray, bl, n);
        assert (precisionType == PrecisionType.FULL) : "Integrated Process is only implemented for full precision type.";
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        int n2;
        assert (this.numTraits == 1);
        assert (this.precisionType == PrecisionType.FULL);
        double[] dArray = super.getTipPartial(n, bl);
        int n3 = 2 * this.dimTrait;
        int n4 = this.precisionType.getPartialsDimension(n3);
        double[] dArray2 = new double[n4];
        System.arraycopy(dArray, 0, dArray2, this.dimTrait, this.dimTrait);
        MissingOps.blockUnwrap(MissingOps.wrap(dArray, this.precisionType.getPrecisionOffset(this.dimTrait), this.dimTrait, this.dimTrait), dArray2, this.precisionType.getPrecisionOffset(n3), this.dimTrait, this.dimTrait, n3);
        int n5 = this.precisionType.getVarianceOffset(n3);
        for (n2 = 0; n2 < this.dimTrait; ++n2) {
            dArray2[n5 + n2 * n3 + n2] = Double.POSITIVE_INFINITY;
        }
        MissingOps.blockUnwrap(MissingOps.wrap(dArray, this.precisionType.getVarianceOffset(this.dimTrait), this.dimTrait, this.dimTrait), dArray2, n5, this.dimTrait, this.dimTrait, n3);
        n2 = this.precisionType.getEffectiveDimensionOffset(this.dimTrait);
        int n6 = (int)Math.round(dArray[n2]);
        this.precisionType.fillEffDimInPartials(dArray2, 0, n6, n3);
        int n7 = this.precisionType.getDeterminantOffset(this.dimTrait);
        double d = dArray[n7];
        this.precisionType.fillDeterminantInPartials(dArray2, 0, d, n3);
        return dArray2;
    }

    @Override
    public int getTraitDimension() {
        return 2 * this.dimTrait;
    }

    @Override
    public void updateTipDataGradient(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, NodeRef nodeRef, int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public boolean needToUpdateTipDataGradient(int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }
}

