/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood.utilities;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.xml.Reportable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class TreeTraitLogger
implements Loggable,
Reportable {
    private final Tree tree;
    private List<TreeTrait> treeTraits;
    private final NodeRestriction nodeRestriction;
    private final boolean taxonNameExplicit;
    private final Set<String> leafSet;

    public TreeTraitLogger(Tree tree, TreeTrait[] treeTraitArray) {
        this(tree, treeTraitArray, NodeRestriction.ALL, false);
    }

    public TreeTraitLogger(Tree tree, TreeTrait[] treeTraitArray, NodeRestriction nodeRestriction, boolean bl) {
        this.tree = tree;
        this.nodeRestriction = nodeRestriction;
        this.taxonNameExplicit = bl;
        this.leafSet = null;
        this.addTraits(treeTraitArray);
    }

    public TreeTraitLogger(Tree tree, TreeTrait[] treeTraitArray, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        this.tree = tree;
        this.nodeRestriction = NodeRestriction.ALL;
        this.taxonNameExplicit = false;
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        this.addTraits(treeTraitArray);
    }

    private void addTraits(TreeTrait[] treeTraitArray) {
        if (this.treeTraits == null) {
            this.treeTraits = new ArrayList<TreeTrait>();
        }
        this.treeTraits.addAll(Arrays.asList(treeTraitArray));
    }

    @Override
    public LogColumn[] getColumns() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        for (final TreeTrait treeTrait : this.treeTraits) {
            if (this.leafSet != null) {
                LogColumn.Abstract abstract_ = new LogColumn.Abstract(treeTrait.getTraitName()){

                    @Override
                    protected String getFormattedValue() {
                        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(TreeTraitLogger.this.tree, TreeTraitLogger.this.leafSet);
                        if (nodeRef != null) {
                            return treeTrait.getTraitString(TreeTraitLogger.this.tree, nodeRef);
                        }
                        return "-";
                    }
                };
                arrayList.add(abstract_);
                continue;
            }
            if (treeTrait.getIntent() == TreeTrait.Intent.WHOLE_TREE) {
                LogColumn.Abstract abstract_ = new LogColumn.Abstract(treeTrait.getTraitName()){

                    @Override
                    protected String getFormattedValue() {
                        return treeTrait.getTraitString(TreeTraitLogger.this.tree, null);
                    }
                };
                arrayList.add(abstract_);
                continue;
            }
            for (int i = this.nodeRestriction.begin(this.tree); i < this.nodeRestriction.end(this.tree); ++i) {
                Serializable serializable;
                final NodeRef nodeRef = this.tree.getNode(i);
                String string = null;
                if (this.taxonNameExplicit) {
                    serializable = this.tree.getNodeTaxon(nodeRef);
                    String string2 = string = serializable != null ? serializable.getId() : null;
                }
                if (this.tree.isRoot(nodeRef) && treeTrait.getIntent() != TreeTrait.Intent.NODE) continue;
                if (treeTrait instanceof TreeTrait.DA) {
                    int n = ((double[])treeTrait.getTrait(this.tree, nodeRef)).length;
                    for (int j = 0; j < n; ++j) {
                        final int n2 = j;
                        LogColumn.Abstract abstract_ = new LogColumn.Abstract(treeTrait.getTraitName() + "." + (string != null ? string : Integer.valueOf(i + 1)) + "." + (j + 1)){

                            @Override
                            protected String getFormattedValue() {
                                double[] dArray = (double[])treeTrait.getTrait(TreeTraitLogger.this.tree, nodeRef);
                                return Double.toString(dArray[n2]);
                            }
                        };
                        arrayList.add(abstract_);
                    }
                    continue;
                }
                serializable = new LogColumn.Abstract(treeTrait.getTraitName() + "." + (i + 1)){

                    @Override
                    protected String getFormattedValue() {
                        return treeTrait.getTraitString(TreeTraitLogger.this.tree, nodeRef);
                    }
                };
                arrayList.add(serializable);
            }
        }
        return arrayList.toArray(new LogColumn[arrayList.size()]);
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LogColumn logColumn : this.getColumns()) {
            stringBuilder.append(logColumn.getFormatted());
            stringBuilder.append("\t");
        }
        return stringBuilder.toString();
    }

    public static enum NodeRestriction {
        ALL{

            @Override
            int begin(Tree tree) {
                return 0;
            }

            @Override
            int end(Tree tree) {
                return tree.getNodeCount();
            }
        }
        ,
        EXTERNAL{

            @Override
            int begin(Tree tree) {
                return 0;
            }

            @Override
            int end(Tree tree) {
                return tree.getExternalNodeCount();
            }
        }
        ,
        INTERNAL{

            @Override
            int begin(Tree tree) {
                return tree.getExternalNodeCount();
            }

            @Override
            int end(Tree tree) {
                return tree.getNodeCount();
            }
        }
        ,
        ROOT{

            @Override
            int begin(Tree tree) {
                assert (tree.getNode(tree.getRoot().getNumber()) == tree.getRoot());
                return tree.getRoot().getNumber();
            }

            @Override
            int end(Tree tree) {
                return tree.getRoot().getNumber() + 1;
            }
        };


        abstract int begin(Tree var1);

        abstract int end(Tree var1);

        public static NodeRestriction parse(String string) {
            String string2 = string.toLowerCase();
            if (string2.compareTo("external") == 0) {
                return EXTERNAL;
            }
            if (string2.compareTo("internal") == 0) {
                return INTERNAL;
            }
            if (string2.compareTo("root") == 0) {
                return ROOT;
            }
            return ALL;
        }
    }
}

