/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.math.LogTricks;
import dr.math.MathUtils;
import dr.util.TaskListener;
import java.util.ArrayList;
import java.util.List;

public class MarginalLikelihoodAnalysis {
    private final String traceName;
    private final List<Double> sample;
    private final long burnin;
    private final String analysisType;
    private final int bootstrapLength;
    private boolean marginalLikelihoodCalculated = false;
    private double logMarginalLikelihood;
    private double bootstrappedSE;
    private TaskListener listener = null;

    public String getTraceName() {
        return this.traceName;
    }

    public long getBurnin() {
        return this.burnin;
    }

    public MarginalLikelihoodAnalysis(List<Double> list, String string, long l, String string2, int n) {
        this.sample = list;
        this.traceName = string;
        this.burnin = l;
        this.analysisType = string2;
        this.bootstrapLength = n;
    }

    public double calculateLogMarginalLikelihood(List<Double> list) {
        if (this.analysisType.equals("aicm")) {
            return this.logMarginalLikelihoodAICM(list);
        }
        if (this.analysisType.equals("smoothed")) {
            return this.logMarginalLikelihoodSmoothed(list);
        }
        if (this.analysisType.equals("arithmetic")) {
            return this.logMarginalLikelihoodArithmetic(list);
        }
        return this.logMarginalLikelihoodHarmonic(list);
    }

    public double logMarginalLikelihoodArithmetic(List<Double> list) {
        int n = list.size();
        double d = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(list.get(i)) && !Double.isInfinite(list.get(i))) {
                d = LogTricks.logSum(d, list.get(i));
                continue;
            }
            --n;
        }
        return d - StrictMath.log(n);
    }

    public double logMarginalLikelihoodHarmonic(List<Double> list) {
        double d = 0.0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            d += list.get(i).doubleValue();
        }
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            d2 = LogTricks.logSum(d2, d - list.get(i));
        }
        return d - d2 + StrictMath.log(n);
    }

    public double logMarginalLikelihoodAICM(List<Double> list) {
        double d = 0.0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            d += list.get(i).doubleValue();
        }
        double d2 = d / (double)n;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += (list.get(i) - d2) * (list.get(i) - d2);
        }
        return 2.0 * (d3 /= (double)n - 1.0) - 2.0 * d2;
    }

    public void calculate() {
        this.logMarginalLikelihood = this.calculateLogMarginalLikelihood(this.sample);
        if (this.bootstrapLength > 1) {
            int n = this.sample.size();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Double[] doubleArray = new Double[this.bootstrapLength];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0 / (double)this.bootstrapLength;
            for (int i = 0; i < this.bootstrapLength; ++i) {
                this.fireProgress(d2);
                d2 += d3;
                int[] nArray = MathUtils.sampleIndicesWithReplacement(n);
                for (int j = 0; j < n; ++j) {
                    arrayList.add(this.sample.get(nArray[j]));
                }
                doubleArray[i] = this.calculateLogMarginalLikelihood(arrayList);
                d += doubleArray[i].doubleValue();
                arrayList.clear();
            }
            double d4 = d /= (double)this.bootstrapLength;
            double d5 = 0.0;
            for (int i = 0; i < this.bootstrapLength; ++i) {
                d5 += (doubleArray[i] - d4) * (doubleArray[i] - d4);
            }
            this.bootstrappedSE = Math.sqrt(d5 /= (double)this.bootstrapLength - 1.0);
        }
        this.fireProgress(1.0);
        this.marginalLikelihoodCalculated = true;
    }

    public double logMarginalLikelihoodSmoothed(List<Double> list, double d, double d2) {
        double d3 = StrictMath.log(d);
        double d4 = StrictMath.log(1.0 - d);
        int n = list.size();
        double d5 = StrictMath.log(n);
        double d6 = d4 - d2;
        double d7 = d5 + d3 - d4;
        double d8 = d7 + d2;
        for (int i = 0; i < n; ++i) {
            double d9 = -LogTricks.logSum(d3, d6 + list.get(i));
            d8 = LogTricks.logSum(d8, d9 + list.get(i));
            d7 = LogTricks.logSum(d7, d9);
        }
        return d8 - d7;
    }

    public double getLogMarginalLikelihood() {
        if (!this.marginalLikelihoodCalculated) {
            this.calculate();
        }
        return this.logMarginalLikelihood;
    }

    public double getBootstrappedSE() {
        if (!this.marginalLikelihoodCalculated) {
            this.calculate();
        }
        return this.bootstrappedSE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.analysisType.equals("smoothed")) {
            stringBuilder.append("log marginal likelihood (using smoothed harmonic mean)");
        } else if (this.analysisType.equals("aicm")) {
            stringBuilder.append("AICM");
        } else if (this.analysisType.equals("arithmetic")) {
            stringBuilder.append("log marginal likelihood (using arithmetic mean)");
        } else {
            stringBuilder.append("log marginal likelihood (using harmonic mean)");
        }
        stringBuilder.append(" from ").append(this.traceName).append(" = ").append(String.format("%5.4f", this.getLogMarginalLikelihood()));
        if (this.bootstrapLength > 1) {
            stringBuilder.append(" +/- ").append(String.format("%5.4f", this.getBootstrappedSE()));
        } else {
            stringBuilder.append("           ");
        }
        stringBuilder.append(" burnin=").append(this.burnin);
        if (this.bootstrapLength > 1) {
            stringBuilder.append(" replicates=").append(this.bootstrapLength);
        }
        return stringBuilder.toString();
    }

    public double logMarginalLikelihoodSmoothed(List<Double> list) {
        double d = this.logMarginalLikelihoodHarmonic(list);
        double d2 = 1.0;
        int n = 0;
        while (Math.abs(d2) > 0.001) {
            double d3;
            double d4 = this.logMarginalLikelihoodSmoothed(list, 0.01, d) - d;
            double d5 = d + d4;
            double d6 = d4 * 10.0;
            double d7 = this.logMarginalLikelihoodSmoothed(list, 0.01, d + d6) - (d + d6);
            double d8 = (d7 - d4) / d6;
            double d9 = d - d4 / d8;
            if (d9 < 2.0 * d || d9 > 0.0 || d9 > 0.5 * d) {
                d9 = d + 10.0 * d4;
            }
            if (Math.abs(d3 = this.logMarginalLikelihoodSmoothed(list, 0.01, d9) - d9) <= Math.abs(d7) && (d3 > 0.0 || Math.abs(d8) > 0.01)) {
                d2 = d9 - d;
                d = d9;
            } else if (Math.abs(d7) <= Math.abs(d4)) {
                d2 = (d5 += d7) - d;
                d = d5;
            } else {
                d2 = d4;
                d += d4;
            }
            if (++n <= 400) continue;
            System.err.println("Probabilities are not converging!!!");
            return -1.7976931348623157E308;
        }
        return d;
    }

    public void setTaskListener(TaskListener taskListener) {
        this.listener = taskListener;
    }

    private void fireProgress(double d) {
        if (this.listener != null) {
            this.listener.progress(d);
        }
    }
}

