/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.matrixAlgebra.Vector;
import java.util.Arrays;

public class WishartSufficientStatistics {
    private int df;
    private final double[] scaleMatrix;

    public WishartSufficientStatistics(int n) {
        this.df = 0;
        this.scaleMatrix = new double[n * n];
    }

    public WishartSufficientStatistics(int n, double[] dArray) {
        this.df = n;
        this.scaleMatrix = dArray;
    }

    public WishartSufficientStatistics clone() {
        return new WishartSufficientStatistics(this.df, (double[])this.scaleMatrix.clone());
    }

    public void copyTo(WishartSufficientStatistics wishartSufficientStatistics) {
        assert (wishartSufficientStatistics != null);
        wishartSufficientStatistics.df = this.df;
        System.arraycopy(this.scaleMatrix, 0, wishartSufficientStatistics.scaleMatrix, 0, this.scaleMatrix.length);
    }

    public WishartSufficientStatistics(int[] nArray, double[] dArray) {
        this(WishartSufficientStatistics.sum(nArray), WishartSufficientStatistics.accumulateMatrix(dArray, nArray.length));
    }

    public final int getDf() {
        return this.df;
    }

    public final double[] getScaleMatrix() {
        return this.scaleMatrix;
    }

    public final void incrementDf(int n) {
        this.df += n;
    }

    public final void clear() {
        this.df = 0;
        Arrays.fill(this.scaleMatrix, 0.0);
    }

    private static double[] accumulateMatrix(double[] dArray, int n) {
        if (n == 1) {
            return dArray;
        }
        int n2 = dArray.length / n;
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        for (int i = 1; i < n; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n2; ++j) {
                int n4 = j;
                dArray2[n4] = dArray2[n4] + dArray[n3 + j];
            }
        }
        return dArray2;
    }

    private static int sum(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    public String toString() {
        return this.df + " : " + new Vector(this.scaleMatrix).toString();
    }
}

