/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.WrappedVector;

public interface ReadableVector {
    public double get(int var1);

    public int getDim();

    public static class Utils {
        public static void setParameter(double[] dArray, Parameter parameter) {
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                parameter.setParameterValueQuietly(i, dArray[i]);
            }
            parameter.fireParameterChangedEvent();
        }

        public static void setParameter(ReadableVector readableVector, Parameter parameter) {
            int n = readableVector.getDim();
            for (int i = 0; i < n; ++i) {
                parameter.setParameterValueQuietly(i, readableVector.get(i));
            }
            parameter.fireParameterChangedEvent();
        }

        public static void setParameter(WrappedVector wrappedVector, Parameter.Default default_) {
            double[] dArray = default_.inspectParameterValues();
            double[] dArray2 = wrappedVector.getBuffer();
            int n = wrappedVector.getOffset();
            int n2 = wrappedVector.getDim();
            for (int i = 0; i < n2; ++i) {
                dArray[i] = dArray2[n + i];
            }
            default_.fireParameterChangedEvent();
        }

        public static double innerProduct(ReadableVector readableVector, ReadableVector readableVector2) {
            assert (readableVector.getDim() == readableVector2.getDim());
            double d = 0.0;
            int n = readableVector.getDim();
            for (int i = 0; i < n; ++i) {
                d += readableVector.get(i) * readableVector2.get(i);
            }
            return d;
        }

        public static double innerProduct(WrappedVector wrappedVector, WrappedVector wrappedVector2) {
            assert (wrappedVector.getDim() == wrappedVector2.getDim());
            double[] dArray = wrappedVector.getBuffer();
            double[] dArray2 = wrappedVector2.getBuffer();
            int n = wrappedVector.getOffset();
            int n2 = wrappedVector2.getOffset();
            double d = 0.0;
            int n3 = dArray.length;
            for (int i = 0; i < n3; ++i) {
                d += dArray[n + i] * dArray2[n2 + i];
            }
            return d;
        }

        public static double norm(ReadableVector readableVector) {
            return Math.sqrt(Utils.innerProduct(readableVector, readableVector));
        }

        public static double[] toArray(ReadableVector readableVector) {
            int n = readableVector.getDim();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = readableVector.get(i);
            }
            return dArray;
        }
    }

    public static class View
    implements ReadableVector {
        private final ReadableVector buffer;
        private final int offset;
        private final int length;

        public View(ReadableVector readableVector, int n, int n2) {
            this.buffer = readableVector;
            this.offset = n;
            this.length = n2;
        }

        @Override
        public double get(int n) {
            return this.buffer.get(this.offset + n);
        }

        @Override
        public int getDim() {
            return this.length;
        }
    }

    public static class Scale
    implements ReadableVector {
        private final ReadableVector vector;
        private final double scalar;

        public Scale(double d, ReadableVector readableVector) {
            this.vector = readableVector;
            this.scalar = d;
        }

        @Override
        public double get(int n) {
            return this.scalar * this.vector.get(n);
        }

        @Override
        public int getDim() {
            return this.vector.getDim();
        }
    }

    public static class Product
    implements ReadableVector {
        private final ReadableVector lhs;
        private final ReadableVector rhs;

        public Product(ReadableVector readableVector, ReadableVector readableVector2) {
            this.lhs = readableVector;
            this.rhs = readableVector2;
        }

        @Override
        public double get(int n) {
            return this.lhs.get(n) * this.rhs.get(n);
        }

        @Override
        public int getDim() {
            return Math.min(this.lhs.getDim(), this.rhs.getDim());
        }
    }

    public static class Quotient
    implements ReadableVector {
        private final ReadableVector numerator;
        private final ReadableVector denominator;

        public Quotient(ReadableVector readableVector, ReadableVector readableVector2) {
            this.numerator = readableVector;
            this.denominator = readableVector2;
        }

        @Override
        public double get(int n) {
            return this.numerator.get(n) / this.denominator.get(n);
        }

        @Override
        public int getDim() {
            return Math.min(this.numerator.getDim(), this.denominator.getDim());
        }
    }

    public static class Sum
    implements ReadableVector {
        private final ReadableVector lhs;
        private final ReadableVector rhs;

        public Sum(ReadableVector readableVector, ReadableVector readableVector2) {
            this.lhs = readableVector;
            this.rhs = readableVector2;
        }

        @Override
        public double get(int n) {
            return this.lhs.get(n) + this.rhs.get(n);
        }

        @Override
        public int getDim() {
            return Math.min(this.lhs.getDim(), this.rhs.getDim());
        }
    }
}

