/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ohdsi.circe.cohortdefinition.ConceptSet;
import org.ohdsi.circe.cohortdefinition.ConceptSetSelection;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.LocationRegion;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

class CriteriaCheckerFactory {
    private ConceptSet conceptSet;

    private CriteriaCheckerFactory(ConceptSet concept) {
        this.conceptSet = concept;
    }

    static CriteriaCheckerFactory getFactory(ConceptSet conceptSet) {
        return new CriteriaCheckerFactory(conceptSet);
    }

    Function<Criteria, Boolean> getCriteriaChecker(Criteria criteria) {
        Function<Criteria, Boolean> result = c -> false;
        if (criteria instanceof ConditionEra) {
            result = c -> Objects.equals(((ConditionEra)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof ConditionOccurrence) {
            result = c -> Objects.equals(((ConditionOccurrence)c).codesetId, this.conceptSet.id) || Objects.equals(((ConditionOccurrence)c).conditionSourceConcept, this.conceptSet.id);
        } else if (criteria instanceof Death) {
            result = c -> Objects.equals(((Death)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof DeviceExposure) {
            result = c -> Objects.equals(((DeviceExposure)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof DoseEra) {
            result = c -> Objects.equals(((DoseEra)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof DrugEra) {
            result = c -> Objects.equals(((DrugEra)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof DrugExposure) {
            result = c -> Objects.equals(((DrugExposure)c).codesetId, this.conceptSet.id) || Objects.equals(((DrugExposure)c).drugSourceConcept, this.conceptSet.id);
        } else if (criteria instanceof Measurement) {
            result = c -> Objects.equals(((Measurement)c).codesetId, this.conceptSet.id) || Objects.equals(((Measurement)c).measurementSourceConcept, this.conceptSet.id);
        } else if (criteria instanceof Observation) {
            result = c -> Objects.equals(((Observation)c).codesetId, this.conceptSet.id) || Objects.equals(((Observation)c).observationSourceConcept, this.conceptSet.id);
        } else if (criteria instanceof ProcedureOccurrence) {
            result = c -> Objects.equals(((ProcedureOccurrence)c).codesetId, this.conceptSet.id) || Objects.equals(((ProcedureOccurrence)c).procedureSourceConcept, this.conceptSet.id);
        } else if (criteria instanceof Specimen) {
            result = c -> Objects.equals(((Specimen)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof VisitOccurrence) {
            result = c -> Objects.equals(((VisitOccurrence)c).codesetId, this.conceptSet.id);
        } else if (criteria instanceof VisitDetail) {
            result = c -> Objects.equals(((VisitDetail)c).codesetId, this.conceptSet.id) || this.checkConceptSetSelection((Criteria)c);
        } else if (criteria instanceof LocationRegion) {
            result = c -> Objects.equals(((LocationRegion)c).codesetId, this.conceptSet.id);
        }
        return result;
    }

    private boolean checkConceptSetSelection(Criteria criteria) {
        boolean result = false;
        for (Supplier<ConceptSetSelection> supplier : CriteriaCheckerFactory.getSuppliers(criteria)) {
            ConceptSetSelection conceptSetSelection = supplier.get();
            if (!Objects.nonNull(conceptSetSelection)) continue;
            result = result || Objects.equals(conceptSetSelection.codesetId, this.conceptSet.id);
        }
        return result;
    }

    private static <T extends Criteria> List<Supplier<ConceptSetSelection>> getSuppliers(T criteria) {
        ArrayList<Supplier<ConceptSetSelection>> suppliers = new ArrayList<Supplier<ConceptSetSelection>>();
        if (criteria instanceof VisitDetail) {
            suppliers.add(() -> ((VisitDetail)criteria).placeOfServiceCS);
            suppliers.add(() -> ((VisitDetail)criteria).genderCS);
            suppliers.add(() -> ((VisitDetail)criteria).providerSpecialtyCS);
            suppliers.add(() -> ((VisitDetail)criteria).visitDetailTypeCS);
        }
        return suppliers;
    }
}

