/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.Comparisons;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConceptSet;

public class DuplicatesConceptSetCheck
extends BaseCheck {
    private static final String DUPLICATES_WARNING = "Concept set %s contains the same concepts like %s";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        if (expression.conceptSets.length > 1) {
            int size = expression.conceptSets.length;
            for (int i = 0; i <= size - 2; ++i) {
                ConceptSet conceptSet = expression.conceptSets[i];
                List duplicates = Arrays.asList(expression.conceptSets).subList(i + 1, size).stream().filter(Comparisons.compare(conceptSet)).collect(Collectors.toList());
                if (duplicates.isEmpty()) continue;
                String names = duplicates.stream().map(cs -> cs.name).collect(Collectors.joining(", "));
                reporter.add(DUPLICATES_WARNING, conceptSet.name, names);
            }
        }
    }
}

