/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.analysis.versioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.semver4j.Semver;

public class SemverUtils {
    private SemverUtils() {
    }

    public static String getRangesIntersection(List<String> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            throw new IllegalArgumentException("ranges parameter can not be null or empty");
        }
        HashSet<String> distinctRanges = new HashSet<String>(ranges);
        if (distinctRanges.size() == 1) {
            return ranges.get(0);
        }
        List<String> validRanges = SemverUtils.findValidRanges(distinctRanges);
        if (validRanges.isEmpty()) {
            return null;
        }
        if (validRanges.size() == 1) {
            return validRanges.get(0);
        }
        return SemverUtils.handleBoundedRange(validRanges);
    }

    private static List<String> findValidRanges(Set<String> ranges) {
        return ranges.stream().filter(r -> !r.equals("*")).map(rng -> {
            List<String> items = SemverUtils.splitRange(rng);
            ArrayList<String> result = new ArrayList<String>();
            if (items.size() == 1) {
                Semver semver = SemverUtils.findBoundary(rng);
                if (ranges.stream().allMatch(arg_0 -> ((Semver)semver).satisfies(arg_0))) {
                    result.add((String)rng);
                }
            } else {
                Semver lower = SemverUtils.findBoundary(items.get(0));
                if (ranges.stream().allMatch(arg_0 -> ((Semver)lower).satisfies(arg_0))) {
                    result.add(">=" + lower);
                }
                Semver upper = SemverUtils.findBoundary(items.get(1));
                if (ranges.stream().allMatch(arg_0 -> ((Semver)upper).satisfies(arg_0))) {
                    result.add("<=" + items.get(1));
                }
            }
            return result;
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private static List<String> splitRange(String range) {
        if (range.contains("-")) {
            String[] boundaries = range.split("-");
            return Arrays.asList(boundaries[0].trim(), boundaries[1].trim());
        }
        return Collections.singletonList(range.trim());
    }

    private static Semver findBoundary(String range) {
        String withoutOperator = SemverUtils.removeOperator(range);
        Semver boundary = Semver.coerce((String)withoutOperator);
        if (withoutOperator.equals(range) || range.contains("=")) {
            return boundary;
        }
        if (range.contains(">")) {
            return boundary.withIncPatch();
        }
        if (range.contains("<")) {
            if (boundary.getPatch() != 0) {
                return boundary.withIncPatch(-1);
            }
            if (boundary.getMinor() != 0) {
                return boundary.withIncMinor(-1);
            }
            return new Semver(boundary.getMajor() - 1 + ".99.99");
        }
        throw new IllegalArgumentException(range + " is not a valid version range. Please use only things  5.3, >=5.2.0, 3 - 5, <6.0.0");
    }

    private static String removeOperator(String range) {
        return range.replaceAll("[^\\d.]", "");
    }

    private static String handleBoundedRange(List<String> satisfactoryRanges) {
        Semver min;
        Semver max = satisfactoryRanges.stream().map(SemverUtils::findBoundary).max(Semver::compareTo).get();
        if (max.equals((Object)(min = satisfactoryRanges.stream().map(SemverUtils::findBoundary).min(Semver::compareTo).get()))) {
            return max.toString();
        }
        return min + " - " + max;
    }
}

