/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.hmc.HamiltonianMonteCarloOperator;
import dr.inference.operators.hmc.MassPreconditioningOptions;

public interface MassPreconditionScheduler {
    public boolean shouldUpdatePreconditioning();

    public boolean shouldStoreSecant(double[] var1, double[] var2);

    public void forceUpdateCount();

    public static class Default
    implements MassPreconditionScheduler {
        private MassPreconditioningOptions options;
        private MCMCOperator operator;
        private int totalUpdates = 0;
        private long paramUpdateCount = 0L;
        private boolean useOperatorCount = true;

        Default(MassPreconditioningOptions options, MCMCOperator operator) {
            this.options = options;
            this.operator = operator;
        }

        @Override
        public boolean shouldUpdatePreconditioning() {
            long count = this.useOperatorCount ? this.operator.getCount() : this.paramUpdateCount;
            boolean shouldUpdate = this.shouldUpdate(count);
            if (shouldUpdate) {
                ++this.totalUpdates;
            }
            return shouldUpdate;
        }

        protected boolean shouldUpdate(long count) {
            return this.options.preconditioningUpdateFrequency() > 0 && count % (long)this.options.preconditioningUpdateFrequency() == 0L && (this.options.preconditioningMaxUpdate() == 0 || this.totalUpdates < this.options.preconditioningMaxUpdate());
        }

        @Override
        public boolean shouldStoreSecant(double[] lastGradient, double[] lastPosition) {
            return lastGradient != null && lastPosition != null;
        }

        @Override
        public void forceUpdateCount() {
            ++this.paramUpdateCount;
            this.useOperatorCount = false;
        }
    }

    public static class None
    implements MassPreconditionScheduler {
        @Override
        public boolean shouldUpdatePreconditioning() {
            return false;
        }

        @Override
        public boolean shouldStoreSecant(double[] lastGradient, double[] lastPosition) {
            return false;
        }

        @Override
        public void forceUpdateCount() {
        }
    }

    public static enum Type {
        NONE("none"){

            @Override
            public MassPreconditionScheduler factory(MassPreconditioningOptions options, MCMCOperator operator) {
                return new None();
            }
        }
        ,
        DEFAULT("default"){

            @Override
            public MassPreconditionScheduler factory(MassPreconditioningOptions options, MCMCOperator operator) {
                return new Default(options, operator);
            }
        };

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public abstract MassPreconditionScheduler factory(MassPreconditioningOptions var1, MCMCOperator var2);

        public String getName() {
            return this.name;
        }

        public static Type parseFromString(String text) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type.name.toLowerCase().compareToIgnoreCase(text) == 0) {
                    return type;
                }
                ++n2;
            }
            return NONE;
        }
    }

    public static class UpdateByProbability
    extends Default {
        UpdateByProbability(HamiltonianMonteCarloOperator.Options options, AdaptableMCMCOperator operator) {
            super(options, (MCMCOperator)operator);
        }
    }
}

