/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.math.distributions.UniformDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.ExposureMisclassifiedLogisticLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;

public class ExposureMisclassifiedAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final OperatorSchedule schedule;
    private final Parameter beta = new Parameter.Default("beta", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Parameter sensitivity = new Parameter.Default("sensitivity", 0.9, 1.0, 0.0);

    public ExposureMisclassifiedAnalysis(SortedCoxData data, double betaPriorMean, double betaPriorSd, double sensitivityLowerBound, double sensitivityUpperBound) {
        this.likelihood = new ExposureMisclassifiedLogisticLikelihood(this.beta, this.sensitivity, data);
        DistributionLikelihood betaPrior = new DistributionLikelihood((Distribution)new NormalDistribution(betaPriorMean, betaPriorSd));
        betaPrior.addData((Attribute)this.beta);
        DistributionLikelihood sensitivityPrior = new DistributionLikelihood((Distribution)new UniformDistribution(sensitivityLowerBound, sensitivityUpperBound));
        sensitivityPrior.addData((Attribute)this.sensitivity);
        this.prior = new CompoundLikelihood(Arrays.asList(betaPrior, sensitivityPrior));
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double defaultWeight = 1.0;
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(this.beta, null, 0.75, condition, defaultWeight, mode));
        this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(this.sensitivity, null, 0.75, condition, defaultWeight, mode));
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        this.likelihood.setId("likelihood");
        this.prior.setId("prior");
        ArrayList<Loggable> columns = new ArrayList<Loggable>();
        columns.add((Loggable)this.likelihood);
        columns.add((Loggable)this.prior);
        columns.add((Loggable)this.beta);
        columns.add((Loggable)this.sensitivity);
        return columns;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] args) {
        int chainLength = 11000;
        int burnIn = 1000;
        int subSampleFrequency = 10;
        SortedCoxData data = ExposureMisclassifiedLogisticLikelihood.exampleData();
        ExposureMisclassifiedAnalysis analysis = new ExposureMisclassifiedAnalysis(data, 0.0, 1.0, 0.8, 1.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        System.out.println();
        runner.processSamples();
    }
}

