/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSampler;

public class FloatRandomSamplingAssistant
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected FloatRandomSampler sampler;
    protected long[] buffer;
    protected int bufferPosition;
    protected long skip;
    protected long n;
    static final int MAX_BUFFER_SIZE = 200;

    public FloatRandomSamplingAssistant(long l, long l2, FloatRandomEngine floatRandomEngine) {
        this.n = l;
        this.sampler = new FloatRandomSampler(l, l2, 0L, floatRandomEngine);
        this.buffer = new long[(int)Math.min(l, 200L)];
        if (l > 0L) {
            this.buffer[0] = -1L;
        }
        this.fetchNextBlock();
    }

    public Object clone() {
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = (FloatRandomSamplingAssistant)super.clone();
        floatRandomSamplingAssistant.sampler = (FloatRandomSampler)this.sampler.clone();
        return floatRandomSamplingAssistant;
    }

    protected void fetchNextBlock() {
        if (this.n > 0L) {
            long l = this.buffer[this.bufferPosition];
            this.sampler.nextBlock((int)Math.min(this.n, 200L), this.buffer, 0);
            this.skip = this.buffer[0] - l - 1L;
            this.bufferPosition = 0;
        }
    }

    public FloatRandomEngine getRandomGenerator() {
        return this.sampler.my_RandomGenerator;
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        FloatRandomSamplingAssistant.testArraySampling((int)l, (int)l2);
    }

    public static int[] sampleArray(int n, int[] nArray) {
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(n, nArray.length, null);
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
            nArray2[n2++] = nArray[i];
        }
        return nArray2;
    }

    public boolean sampleNextElement() {
        if (this.n == 0L) {
            return false;
        }
        if (this.skip-- > 0L) {
            return false;
        }
        --this.n;
        if (this.bufferPosition < this.buffer.length - 1) {
            this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
            --this.skip;
        } else {
            this.fetchNextBlock();
        }
        return true;
    }

    public static void test(long l, long l2) {
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(l, l2, null);
        LongArrayList longArrayList = new LongArrayList((int)l);
        Timer timer = new Timer().start();
        for (long i = 0L; i < l2; ++i) {
            if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
            longArrayList.add(i);
        }
        timer.stop().display();
        System.out.println("sample=" + longArrayList);
        System.out.println("Good bye.\n");
    }

    public static void testArraySampling(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        Timer timer = new Timer().start();
        int[] nArray2 = FloatRandomSamplingAssistant.sampleArray(n, nArray);
        timer.stop().display();
        System.out.println("Good bye.\n");
    }

    private void xsampleNextElements(BooleanArrayList booleanArrayList) {
        int n = booleanArrayList.size();
        boolean[] blArray = booleanArrayList.elements();
        for (int i = 0; i < n; ++i) {
            if (this.n == 0L) {
                blArray[i] = false;
                continue;
            }
            if (this.skip-- > 0L) {
                blArray[i] = false;
                continue;
            }
            --this.n;
            if (this.bufferPosition < this.buffer.length - 1) {
                this.skip = this.buffer[this.bufferPosition + 1] - this.buffer[this.bufferPosition++];
                --this.skip;
            } else {
                this.fetchNextBlock();
            }
            blArray[i] = true;
        }
    }
}

