/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;

public class SCatSequence
extends Notifier {
    int[] seqToCat = null;
    int[] catToSeq = null;
    SVar v;
    int cats;
    Object owner;
    boolean notifyVar = false;

    public SCatSequence(SVar var, Object theOwner, boolean notifyVariable) {
        this.v = var;
        this.owner = theOwner;
        this.cats = this.v != null ? this.v.getNumCats() : 0;
        this.notifyVar = notifyVariable;
    }

    public SCatSequence(SVar var) {
        this(var, null, false);
    }

    public void setNotifyVarOnChange(boolean noc) {
        this.notifyVar = noc;
    }

    public Object getOwner() {
        return this.owner;
    }

    void updateCats() {
        if (this.v == null) {
            return;
        }
        int cc = this.v.getNumCats();
        if (cc == this.cats) {
            return;
        }
        if (cc == 0 || this.seqToCat == null || this.catToSeq == null) {
            this.catToSeq = null;
            this.seqToCat = null;
            this.cats = cc;
            return;
        }
        this.catToSeq = null;
        this.seqToCat = null;
        this.cats = cc;
    }

    public int size() {
        return this.cats;
    }

    public int catAtPos(int id) {
        if (id < 0 || id >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": catAtPos(" + id + ") out of range (" + this.cats + " cats)");
        }
        return this.seqToCat == null ? id : this.seqToCat[id];
    }

    public int posOfCat(int id) {
        if (id < 0 || id >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": posOfCat(" + id + ") out of range (" + this.cats + " cats)");
        }
        return this.catToSeq == null ? id : this.catToSeq[id];
    }

    void createFields() {
        this.catToSeq = null;
        this.seqToCat = null;
        if (this.cats < 1) {
            return;
        }
        this.seqToCat = new int[this.cats];
        this.catToSeq = new int[this.cats];
        for (int i = 0; i < this.cats; ++i) {
            this.seqToCat[i] = i;
            this.catToSeq[i] = i;
        }
    }

    public void reset() {
        if (this.seqToCat != null || this.catToSeq != null) {
            this.catToSeq = null;
            this.seqToCat = null;
            if (this.notifyVar) {
                this.v.NotifyAll(new NotifyMsg(this, 12291));
            } else {
                this.NotifyAll(new NotifyMsg(this, 24576));
            }
        }
    }

    public boolean swapCatsAtPositions(int p1, int p2) {
        int c2;
        if (p1 < 0 || p2 < 0 || p1 >= this.cats || p2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": swapCatsAtPositions(" + p1 + "," + p2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int c1 = this.seqToCat[p1];
        this.seqToCat[p1] = c2 = this.seqToCat[p2];
        this.seqToCat[p2] = c1;
        this.catToSeq[c1] = p2;
        this.catToSeq[c2] = p1;
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public boolean swapCats(int c1, int c2) {
        if (c1 < 0 || c2 < 0 || c1 >= this.cats || c2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": swapCats(" + c1 + "," + c2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int p1 = this.catToSeq[c1];
        int p2 = this.catToSeq[c2];
        this.seqToCat[p1] = c2;
        this.seqToCat[p2] = c1;
        this.catToSeq[c1] = p2;
        this.catToSeq[c2] = p1;
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public boolean moveCatAtPosTo(int p1, int p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 < 0 || p2 < 0 || p1 >= this.cats || p2 >= this.cats) {
            return Global.runtimeWarning("SCatSequence on " + (this.v == null ? "<null>" : this.v.getName()) + ": moveCatAtPosTo(" + p1 + "," + p2 + ") out of range (" + this.cats + " cats)") != -1;
        }
        if (this.seqToCat == null) {
            this.createFields();
        }
        int c1 = this.seqToCat[p1];
        if (p1 < p2) {
            int r = p1;
            while (r < p2) {
                int c;
                this.seqToCat[r] = c = this.seqToCat[r + 1];
                this.catToSeq[c] = r++;
            }
            this.seqToCat[r] = c1;
            this.catToSeq[c1] = r;
        } else {
            int r = p1;
            while (r > p2) {
                int c;
                this.seqToCat[r] = c = this.seqToCat[r - 1];
                this.catToSeq[c] = r--;
            }
            this.seqToCat[r] = c1;
            this.catToSeq[c1] = r;
        }
        if (this.notifyVar) {
            this.v.NotifyAll(new NotifyMsg(this, 12291));
        } else {
            this.NotifyAll(new NotifyMsg(this, 24576));
        }
        return true;
    }

    public String toString() {
        return "SCatSequence(var=\"" + (this.v == null ? "<null>" : this.v.name) + "\",cats=" + this.cats + (this.seqToCat == null ? ",straight" : ",mapped") + ")";
    }
}

