/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class DefaultArimaSpec
implements Cloneable,
InformationSetSerializable {
    public static final String MEAN = "mean";
    public static final String MU = "mu";
    public static final String THETA = "theta";
    public static final String D = "d";
    public static final String PHI = "phi";
    public static final String BTHETA = "btheta";
    public static final String BD = "bd";
    public static final String BPHI = "bphi";
    private Parameter mu;
    private int d_;
    private int bd_;
    private Parameter[] phi_;
    private Parameter[] theta_;
    private Parameter[] bphi_;
    private Parameter[] btheta_;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, MEAN), Boolean.class);
        dic.put(InformationSet.item(prefix, MU), Parameter.class);
        dic.put(InformationSet.item(prefix, D), Integer.class);
        dic.put(InformationSet.item(prefix, BD), Integer.class);
        dic.put(InformationSet.item(prefix, THETA), Parameter[].class);
        dic.put(InformationSet.item(prefix, PHI), Parameter[].class);
        dic.put(InformationSet.item(prefix, BTHETA), Parameter[].class);
        dic.put(InformationSet.item(prefix, BPHI), Parameter[].class);
    }

    public DefaultArimaSpec clone() {
        try {
            DefaultArimaSpec spec = (DefaultArimaSpec)super.clone();
            spec.phi_ = Parameter.clone(this.phi_);
            spec.theta_ = Parameter.clone(this.theta_);
            spec.bphi_ = Parameter.clone(this.bphi_);
            spec.btheta_ = Parameter.clone(this.btheta_);
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean isMean() {
        return this.mu != null;
    }

    public void setMean(boolean mean) {
        this.mu = mean ? new Parameter() : null;
    }

    public Parameter getMu() {
        return this.mu;
    }

    public void setMu(Parameter mu) {
        this.mu = mu;
    }

    public void fixMu() {
        if (this.mu != null) {
            this.mu.setType(ParameterType.Fixed);
        }
    }

    public void setParameterType(ParameterType type) {
        int i;
        if (this.phi_ != null) {
            for (i = 0; i < this.phi_.length; ++i) {
                this.phi_[i].setType(type);
            }
        }
        if (this.bphi_ != null) {
            for (i = 0; i < this.bphi_.length; ++i) {
                this.bphi_[i].setType(type);
            }
        }
        if (this.theta_ != null) {
            for (i = 0; i < this.theta_.length; ++i) {
                this.theta_[i].setType(type);
            }
        }
        if (this.btheta_ != null) {
            for (i = 0; i < this.btheta_.length; ++i) {
                this.btheta_[i].setType(type);
            }
        }
    }

    public void setMAParameterType(ParameterType type) {
        int i;
        if (this.theta_ != null) {
            for (i = 0; i < this.theta_.length; ++i) {
                this.theta_[i].setType(type);
            }
        }
        if (this.btheta_ != null) {
            for (i = 0; i < this.btheta_.length; ++i) {
                this.btheta_[i].setType(type);
            }
        }
    }

    public void setARParameterType(ParameterType type) {
        int i;
        if (this.phi_ != null) {
            for (i = 0; i < this.phi_.length; ++i) {
                this.phi_[i].setType(type);
            }
        }
        if (this.bphi_ != null) {
            for (i = 0; i < this.bphi_.length; ++i) {
                this.bphi_[i].setType(type);
            }
        }
    }

    public void clearParameters() {
        int i;
        if (this.phi_ != null) {
            for (i = 0; i < this.phi_.length; ++i) {
                this.phi_[i] = new Parameter();
            }
        }
        if (this.bphi_ != null) {
            for (i = 0; i < this.bphi_.length; ++i) {
                this.bphi_[i] = new Parameter();
            }
        }
        if (this.theta_ != null) {
            for (i = 0; i < this.theta_.length; ++i) {
                this.theta_[i] = new Parameter();
            }
        }
        if (this.btheta_ != null) {
            for (i = 0; i < this.btheta_.length; ++i) {
                this.btheta_[i] = new Parameter();
            }
        }
    }

    public void clearFreeParameters() {
        int i;
        if (this.phi_ != null) {
            for (i = 0; i < this.phi_.length; ++i) {
                if (this.phi_[i].isFixed()) continue;
                this.phi_[i] = new Parameter();
            }
        }
        if (this.bphi_ != null) {
            for (i = 0; i < this.bphi_.length; ++i) {
                if (this.bphi_[i].isFixed()) continue;
                this.bphi_[i] = new Parameter();
            }
        }
        if (this.theta_ != null) {
            for (i = 0; i < this.theta_.length; ++i) {
                if (this.theta_[i].isFixed()) continue;
                this.theta_[i] = new Parameter();
            }
        }
        if (this.btheta_ != null) {
            for (i = 0; i < this.btheta_.length; ++i) {
                if (this.btheta_[i].isFixed()) continue;
                this.btheta_[i] = new Parameter();
            }
        }
    }

    public boolean hasParameters() {
        return !Parameter.isDefault(this.phi_) || !Parameter.isDefault(this.theta_) || !Parameter.isDefault(this.bphi_) || !Parameter.isDefault(this.btheta_);
    }

    public boolean hasFreeParameters() {
        return Parameter.hasFreeParameters(this.phi_) || Parameter.hasFreeParameters(this.theta_) || Parameter.hasFreeParameters(this.bphi_) || Parameter.hasFreeParameters(this.btheta_);
    }

    public boolean hasFixedParameters() {
        return Parameter.hasFixedParameters(this.phi_) || Parameter.hasFixedParameters(this.theta_) || Parameter.hasFixedParameters(this.bphi_) || Parameter.hasFixedParameters(this.btheta_);
    }

    public void setArimaComponent(SarimaComponent aspec) {
        Parameter m = aspec.getMu();
        this.mu = m == null ? null : m.clone();
        this.setP(aspec.getP());
        this.setD(aspec.getD());
        this.setQ(aspec.getQ());
        this.setBP(aspec.getBP());
        this.setBD(aspec.getBD());
        this.setBQ(aspec.getBQ());
        this.updateParameters(aspec);
    }

    private void updateParameters(SarimaComponent aspec) {
        this.updateParameters(this.phi_, aspec.getPhi());
        this.updateParameters(this.theta_, aspec.getTheta());
        this.updateParameters(this.bphi_, aspec.getBPhi());
        this.updateParameters(this.btheta_, aspec.getBTheta());
    }

    private void updateParameters(Parameter[] target, Parameter[] source) {
        if (target == null || source == null || target.length != source.length) {
            return;
        }
        for (int i = 0; i < target.length; ++i) {
            if (target[i] != null && target[i].isFixed() || source[i] == null) continue;
            target[i] = source[i].clone();
        }
    }

    public void airline() {
        this.setP(0);
        this.d_ = 1;
        this.setQ(1);
        this.setBP(0);
        this.bd_ = 1;
        this.setBQ(1);
        this.mu = null;
    }

    public void airlineWithMean() {
        this.setP(0);
        this.d_ = 1;
        this.setQ(1);
        this.setBP(0);
        this.bd_ = 1;
        this.setBQ(1);
        this.mu = new Parameter();
    }

    public int getP() {
        return this.phi_ == null ? 0 : this.phi_.length;
    }

    public void setP(int value) {
        this.phi_ = Parameter.create(value);
    }

    public int getD() {
        return this.d_;
    }

    public void setD(int value) {
        this.d_ = value;
    }

    public int getQ() {
        return this.theta_ == null ? 0 : this.theta_.length;
    }

    public void setQ(int value) {
        this.theta_ = Parameter.create(value);
    }

    public int getBP() {
        return this.bphi_ == null ? 0 : this.bphi_.length;
    }

    public void setBP(int value) {
        this.bphi_ = Parameter.create(value);
    }

    public int getBD() {
        return this.bd_;
    }

    public void setBD(int value) {
        this.bd_ = value;
    }

    public int getBQ() {
        return this.btheta_ == null ? 0 : this.btheta_.length;
    }

    public void setBQ(int value) {
        this.btheta_ = Parameter.create(value);
    }

    public boolean isAirline() {
        return this.getP() == 0 && this.d_ == 1 && this.getQ() == 1 && this.getBP() == 0 && this.bd_ == 1 && this.getBQ() == 1;
    }

    public boolean isDefault() {
        return this.mu == null && this.isAirline() && Parameter.isDefault(this.phi_) && Parameter.isDefault(this.theta_) && Parameter.isDefault(this.bphi_) && Parameter.isDefault(this.btheta_);
    }

    public Parameter[] getPhi() {
        return this.phi_;
    }

    public void setPhi(Parameter[] value) {
        this.phi_ = value;
    }

    public Parameter[] getTheta() {
        return this.theta_;
    }

    public void setTheta(Parameter[] value) {
        this.theta_ = value;
    }

    public Parameter[] getBPhi() {
        return this.bphi_;
    }

    public void setBPhi(Parameter[] value) {
        this.bphi_ = value;
    }

    public Parameter[] getBTheta() {
        return this.btheta_;
    }

    public void setBTheta(Parameter[] value) {
        this.btheta_ = value;
    }

    public SarimaSpecification getSpecification(int freq) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setP(this.getP());
        spec.setD(this.d_);
        spec.setQ(this.getQ());
        if (freq > 1) {
            spec.setBP(this.getBP());
            spec.setBD(this.bd_);
            spec.setBQ(this.getBQ());
        }
        return spec;
    }

    public SarimaModel getArima(int freq) {
        int i;
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setP(this.getP());
        spec.setD(this.d_);
        spec.setQ(this.getQ());
        if (freq > 1) {
            spec.setBP(this.getBP());
            spec.setBD(this.bd_);
            spec.setBQ(this.getBQ());
        }
        SarimaModel sarima = new SarimaModel(spec);
        Parameter[] p = this.phi_;
        if (p != null) {
            for (i = 0; i < p.length; ++i) {
                if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
                sarima.setPhi(i + 1, p[i].getValue());
            }
        }
        if ((p = this.theta_) != null) {
            for (i = 0; i < p.length; ++i) {
                if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
                sarima.setTheta(i + 1, p[i].getValue());
            }
        }
        p = this.bphi_;
        if (freq > 1 && p != null) {
            for (i = 0; i < p.length; ++i) {
                if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
                sarima.setBPhi(i + 1, p[i].getValue());
            }
        }
        p = this.btheta_;
        if (freq > 1 && p != null) {
            for (i = 0; i < p.length; ++i) {
                if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
                sarima.setBTheta(i + 1, p[i].getValue());
            }
        }
        return sarima;
    }

    public void setArima(SarimaModel value) {
        int i;
        SarimaSpecification spec = value.getSpecification();
        this.setP(spec.getP());
        this.d_ = spec.getD();
        this.setQ(spec.getQ());
        this.setBP(spec.getBP());
        this.bd_ = spec.getBD();
        this.setBQ(spec.getBQ());
        Parameter[] p = this.phi_;
        if (p != null) {
            for (i = 0; i < p.length; ++i) {
                p[i] = new Parameter(value.phi(i + 1), ParameterType.Estimated);
            }
        }
        if ((p = this.theta_) != null) {
            for (i = 0; i < p.length; ++i) {
                p[i] = new Parameter(value.theta(i + 1), ParameterType.Estimated);
            }
        }
        if ((p = this.bphi_) != null) {
            for (i = 0; i < p.length; ++i) {
                p[i] = new Parameter(value.bphi(i + 1), ParameterType.Estimated);
            }
        }
        if ((p = this.btheta_) != null) {
            for (i = 0; i < p.length; ++i) {
                p[i] = new Parameter(value.btheta(i + 1), ParameterType.Estimated);
            }
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DefaultArimaSpec && this.equals((DefaultArimaSpec)obj);
    }

    private boolean equals(DefaultArimaSpec other) {
        return this.bd_ == other.bd_ && this.d_ == other.d_ && Objects.deepEquals(this.mu, other.mu) && Arrays.deepEquals(this.phi_, other.phi_) && Arrays.deepEquals(this.theta_, other.theta_) && Arrays.deepEquals(this.bphi_, other.bphi_) && Arrays.deepEquals(this.btheta_, other.btheta_);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash;
        hash = 53 * hash + this.d_;
        hash = 53 * hash + this.bd_;
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (this.mu != null) {
            info.add(MU, this.mu);
        }
        if (this.getP() != 0) {
            info.add(PHI, this.phi_);
        }
        if (verbose || this.d_ != 1) {
            info.add(D, Integer.valueOf(this.d_));
        }
        if (this.getQ() != 0) {
            info.add(THETA, this.theta_);
        }
        if (this.getBP() != 0) {
            info.add(BPHI, this.bphi_);
        }
        if (verbose || this.bd_ != 1) {
            info.add(BD, Integer.valueOf(this.bd_));
        }
        if (this.getBQ() != 0) {
            info.add(BTHETA, this.btheta_);
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Integer bd;
            Integer d;
            Parameter m;
            this.airline();
            Boolean mean = info.get(MEAN, Boolean.class);
            if (mean != null) {
                this.mu = new Parameter();
            }
            if ((m = info.get(MU, Parameter.class)) != null) {
                this.mu = m;
            }
            if ((d = info.get(D, Integer.class)) != null) {
                this.d_ = d;
            }
            if ((bd = info.get(BD, Integer.class)) != null) {
                this.bd_ = bd;
            }
            this.setPhi(info.get(PHI, Parameter[].class));
            this.setTheta(info.get(THETA, Parameter[].class));
            this.setBPhi(info.get(BPHI, Parameter[].class));
            this.setBTheta(info.get(BTHETA, Parameter[].class));
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

