/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ArrayState;
import ec.tstoolkit.ssf.FastArrayState;
import ec.tstoolkit.ssf.IArrayFilteringResults;
import ec.tstoolkit.ssf.IFastArrayFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ResidualsCumulator;

public class ArrayFilteringResults
extends ResidualsCumulator
implements IArrayFilteringResults,
IFastArrayFilteringResults {
    private MatrixStorage m_S;
    private DataBlockStorage m_K;
    private DataBlockStorage m_A;
    private DataBlockStorage m_L;
    private double[] m_r;
    private double[] m_e;
    private int m_dim;
    private boolean m_bK;
    private boolean m_bS;
    private boolean m_bA;
    private boolean m_bL;

    public ArrayFilteringResults() {
        this.m_bA = false;
        this.m_bS = false;
        this.m_bK = false;
        this.m_bL = false;
    }

    public ArrayFilteringResults(boolean hasA, boolean hasK) {
        this.m_bA = hasA;
        this.m_bS = false;
        this.m_bK = hasK;
        this.m_bL = false;
    }

    public DataBlock A(int t) {
        return this.m_A == null ? null : this.m_A.block(t);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_n = 0;
        this.m_dim = 0;
        this.m_S = null;
        this.m_K = null;
        this.m_e = null;
        this.m_A = null;
        this.m_r = null;
        this.m_L = null;
    }

    @Override
    public void close() {
    }

    public double E(int t) {
        return this.m_e == null ? 0.0 : this.m_e[t];
    }

    public double F(int t) {
        return this.m_r[t];
    }

    public double[] getResiduals() {
        if (this.m_e == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < this.m_e.length; ++i) {
            if (Double.isNaN(this.m_e[i])) continue;
            ++n;
        }
        if (n == 0) {
            return this.m_e;
        }
        double[] res = new double[n];
        n = 0;
        for (int i = 0; i < this.m_e.length; ++i) {
            if (Double.isNaN(this.m_e[i])) continue;
            res[n++] = this.m_e[i] / this.m_r[i];
        }
        return res;
    }

    public boolean isMissing(int t) {
        return this.m_e == null ? false : Double.isNaN(this.m_e[t]);
    }

    public boolean isSavingA() {
        return this.m_bA;
    }

    public boolean isSavingK() {
        return this.m_bK;
    }

    public boolean isSavingL() {
        return this.m_bL;
    }

    public boolean isSavingS() {
        return this.m_bS;
    }

    public DataBlock K(int t) {
        return this.m_K == null ? null : this.m_K.block(t);
    }

    public DataBlock L(int t) {
        return this.m_L == null ? null : this.m_L.block(t);
    }

    @Override
    public void prepare(ISsf ssf, ISsfData data) {
        this.clear();
        this.m_dim = ssf.getStateDim();
        int n = data.getCount();
        boolean hasdata = data.hasData();
        if (hasdata) {
            if (this.m_bA) {
                this.m_A = new DataBlockStorage(this.m_dim, n);
            }
            this.m_e = new double[n];
            for (int i = 0; i < n; ++i) {
                this.m_e[i] = Double.NaN;
            }
        }
        this.m_r = new double[n];
        if (this.m_bK) {
            this.m_K = new DataBlockStorage(this.m_dim, n);
        }
        if (this.m_bL) {
            this.m_L = new DataBlockStorage(this.m_dim, n);
        } else if (this.m_bS) {
            this.m_S = new MatrixStorage(this.m_dim, n);
        }
    }

    public SubMatrix S(int t) {
        if (this.m_S == null) {
            return null;
        }
        return this.m_S.matrix(t);
    }

    @Override
    public void save(int t, ArrayState state) {
        this.m_r[t] = state.r;
        if (this.m_e != null) {
            if (state.isMissing()) {
                this.m_e[t] = Double.NaN;
            } else {
                this.add(state.e, state.r * state.r);
                this.m_e[t] = state.e;
            }
        }
        if (this.m_bA) {
            this.m_A.save(t, state.A);
        }
        if (this.m_bK) {
            this.m_K.save(t, state.K);
        }
        if (this.m_bS) {
            this.m_S.save(t, state.S);
        }
    }

    @Override
    public void save(int t, FastArrayState state) {
        this.m_r[t] = state.r;
        this.add(state.e, state.r * state.r);
        this.m_e[t] = state.e;
        if (this.m_bA) {
            this.m_A.save(t, state.A);
        }
        if (this.m_bK) {
            this.m_K.save(t, state.K);
        }
        if (this.m_bL) {
            this.m_L.save(t, state.L);
        }
    }

    public void setSavingA(boolean value) {
        this.m_bA = value;
    }

    public void setSavingK(boolean value) {
        this.m_bK = value;
    }

    public void setSavingL(boolean value) {
        this.m_bL = value;
        if (this.m_bL) {
            this.m_bS = false;
        }
    }

    public void setSavingS(boolean value) {
        this.m_bS = value;
        if (this.m_bS) {
            this.m_bL = false;
        }
    }
}

