/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyPartition;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyRule;

public class FuzzyClassifier {
    public double[][] ejemplos;
    public double[][] deseado;
    public int nentradas;
    public int nsalidas;
    public int nelem;
    public int[] nejemplos;
    public final double ACT_MIN = 0.0;
    public final double PENAL_CUB = 0.0;
    public final double MIN_CONS = 0.0;
    public FuzzyPartition[] Etiquetas;
    public FuzzyRule[] BaseConocimiento;

    public FuzzyClassifier(double[][] vejemplos, double[][] vdeseado) {
        this.ejemplos = vejemplos;
        this.deseado = vdeseado;
        this.nentradas = this.ejemplos[0].length;
        this.nsalidas = this.deseado[0].length;
        this.nelem = this.ejemplos.length;
        this.nejemplos = new int[this.nsalidas];
        for (int i = 0; i < this.nelem; ++i) {
            for (int s = 0; s < this.nsalidas; ++s) {
                if (this.deseado[i][s] == 0.0) continue;
                int n = s;
                this.nejemplos[n] = this.nejemplos[n] + 1;
            }
        }
        this.Etiquetas = new FuzzyPartition[this.nentradas];
        this.BaseConocimiento = new FuzzyRule[0];
    }

    public String AString(double[] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + s[i] + " ";
        }
        return result + "]";
    }

    public String AString(int[] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + s[i] + " ";
        }
        return result + "]";
    }

    public String AString(int[][] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + this.AString(s[i]) + " ";
        }
        return result + "]";
    }

    public String AString(double[][] s) {
        String result = "[";
        for (int i = 0; i < s.length; ++i) {
            result = result + this.AString(s[i]) + " ";
        }
        return result + "]";
    }

    public double[] Agrega(double[] a, double[] b) {
        double[] res = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] + b[i];
        }
        return res;
    }

    public void EstimaParticiones(int n) {
        double[] tmp = new double[n];
        for (int c = 0; c < this.nentradas; ++c) {
            int i;
            double max = this.ejemplos[0][c];
            double min = this.ejemplos[0][c];
            for (i = 1; i < this.nelem; ++i) {
                if (this.ejemplos[i][c] > max) {
                    max = this.ejemplos[i][c];
                }
                if (!(this.ejemplos[i][c] < min)) continue;
                min = this.ejemplos[i][c];
            }
            for (i = 0; i < n; ++i) {
                tmp[i] = min + (max - min) / (double)(n - 1) * (double)i;
            }
            this.Etiquetas[c] = new FuzzyPartition(tmp);
        }
    }

    public void AlmacenaParametros(double[] bancoreglas) {
        int j;
        int i;
        int p = 0;
        for (i = 0; i < this.nentradas; ++i) {
            bancoreglas[p++] = this.Etiquetas[i].vertices.length;
            for (j = 0; j < this.Etiquetas[i].vertices.length; ++j) {
                bancoreglas[p++] = this.Etiquetas[i].vertices[j];
            }
        }
        bancoreglas[p++] = this.BaseConocimiento.length;
        for (i = 0; i < this.BaseConocimiento.length; ++i) {
            for (j = 0; j < this.BaseConocimiento[i].antecedente.length; ++j) {
                bancoreglas[p++] = this.BaseConocimiento[i].antecedente[j];
            }
            for (j = 0; j < this.BaseConocimiento[i].consecuente.length; ++j) {
                bancoreglas[p++] = this.BaseConocimiento[i].consecuente[j];
            }
        }
    }

    public void RecuperaParametros(double[] bancoreglas) {
        int p = 0;
        for (int i = 0; i < this.nentradas; ++i) {
            int size = (int)bancoreglas[p++];
            double[] tmp = new double[size];
            for (int j = 0; j < tmp.length; ++j) {
                tmp[j] = bancoreglas[p++];
            }
            this.Etiquetas[i] = new FuzzyPartition(tmp);
        }
        int numreglas = (int)bancoreglas[p++];
        this.BaseConocimiento = new FuzzyRule[numreglas];
        for (int i = 0; i < numreglas; ++i) {
            int j;
            int[] tmpa = new int[this.nentradas];
            double[] tmpc = new double[this.nsalidas];
            for (j = 0; j < tmpa.length; ++j) {
                tmpa[j] = (int)bancoreglas[p++];
            }
            for (j = 0; j < tmpc.length; ++j) {
                tmpc[j] = bancoreglas[p++];
            }
            this.BaseConocimiento[i] = new FuzzyRule(tmpa, tmpc);
        }
    }

    public double CertezaAntecedenteEj(int i, FuzzyRule regla, double[][][] Mu) {
        double result = 1.0;
        for (int v = 0; v < regla.antecedente.length; ++v) {
            if (regla.antecedente[v] <= 0) continue;
            result = regla.tnorma(result, Mu[i][v][regla.antecedente[v] - 1]);
        }
        return result;
    }

    public double[] CertezaAntecedente(FuzzyRule regla, double[][][] Mu) {
        double[] result = new double[this.nelem];
        for (int i = 0; i < this.nelem; ++i) {
            result[i] = this.CertezaAntecedenteEj(i, regla, Mu);
        }
        return result;
    }

    public double[] InferenciaBanco(int Clase, double[][][] Mu) {
        double[] result = new double[this.nelem];
        for (int i = 0; i < this.nelem; ++i) {
            double[] suma = new double[this.nsalidas];
            for (int r = 0; r < this.BaseConocimiento.length; ++r) {
                if (this.BaseConocimiento[r].consecuente[Clase] == 0.0) continue;
                double tr = this.CertezaAntecedenteEj(i, this.BaseConocimiento[r], Mu);
                for (int k = 0; k < this.nsalidas; ++k) {
                    int n = k;
                    suma[n] = suma[n] + this.BaseConocimiento[r].consecuente[k] * tr;
                }
            }
            for (int k = 0; k < this.nsalidas; ++k) {
                if (k == Clase) {
                    int n = i;
                    result[n] = result[n] + suma[k];
                    continue;
                }
                int n = i;
                result[n] = result[n] - suma[k];
            }
        }
        return result;
    }

    public int[][] CalculaI(double[][][] Mu, FuzzyRule[] BC) {
        int[][] I = new int[this.nelem][BC.length];
        for (int i = 0; i < this.nelem; ++i) {
            double max = 0.0;
            int imax = 0;
            boolean primera = true;
            for (int r = 0; r < BC.length; ++r) {
                double tr = this.CertezaAntecedenteEj(i, this.BaseConocimiento[r], Mu);
                if (tr == 0.0) continue;
                double act = 0.0;
                for (int c = 0; c < BC[r].consecuente.length; ++c) {
                    double cact = tr * BC[r].consecuente[c];
                    if (!(cact > act) && c != 0) continue;
                    act = cact;
                }
                if (!(act > max) && !primera) continue;
                primera = false;
                max = act;
                imax = r;
            }
            I[i][imax] = 1;
        }
        return I;
    }

    public double[] CalculaSignoDeseado(int Clase) {
        double[] dsigno = new double[this.nelem];
        for (int i = 0; i < this.nelem; ++i) {
            dsigno[i] = this.deseado[i][Clase] != 0.0 ? 1.0 : -1.0;
        }
        return dsigno;
    }

    public void MuestraBase() {
        System.out.println("La base es:");
        for (int i = 0; i < this.BaseConocimiento.length; ++i) {
            System.out.println(this.AString(this.BaseConocimiento[i].antecedente) + "->" + this.AString(this.BaseConocimiento[i].consecuente));
        }
    }
}

