/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCBA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierCBA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Item;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Replace;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Rule;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Selected;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Structure;
import keel.Algorithms.Associative_Classification.ClassifierCBA.myDataset;
import org.core.Fichero;

public class RuleBase {
    ArrayList<Rule> ruleBase;
    ArrayList<Rule> U;
    ArrayList<Rule> Q;
    ArrayList<Selected> C;
    ArrayList<Structure> A;
    DataBase dataBase;
    myDataset train;
    int n_variables;
    int defaultClass;
    double fitness;

    public RuleBase() {
    }

    public RuleBase(DataBase dataBase, myDataset train) {
        this.ruleBase = new ArrayList();
        this.dataBase = dataBase;
        this.train = train;
        this.n_variables = dataBase.numVariables();
        this.fitness = 0.0;
        this.defaultClass = -1;
    }

    public void add(Rule rule) {
        this.ruleBase.add(rule);
    }

    public void add(Itemset itemset, long time) {
        int i;
        int[] antecedent = new int[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            antecedent[i] = -1;
        }
        for (i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            antecedent[item.getVariable()] = item.getValue();
        }
        Rule r = new Rule(this.dataBase);
        r.asignaAntecedente(antecedent);
        r.setConsequent(itemset.getClas());
        r.setConfidence(itemset.getSupportClass() / itemset.getSupport());
        r.setSupport(itemset.getSupportClass());
        r.setTime(time);
        this.ruleBase.add(r);
    }

    public Rule get(int pos) {
        return this.ruleBase.get(pos);
    }

    public void setDefaultClass(int defaultClass) {
        this.defaultClass = defaultClass;
    }

    public int size() {
        return this.ruleBase.size();
    }

    public void sort() {
        Collections.sort(this.ruleBase);
    }

    public Rule remove(int pos) {
        return this.ruleBase.remove(pos);
    }

    public double evaluate() {
        int nHits = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            int Prediction = this.FRM_WR(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) != Prediction) continue;
            ++nHits;
        }
        this.fitness = 100.0 * (double)nHits / (1.0 * (double)this.train.size());
        return this.fitness;
    }

    public int FRM(int[] example) {
        return this.FRM_WR(example);
    }

    private int FRM_WR(int[] example) {
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule r = this.ruleBase.get(i);
            if (!(r.matching(example) > 0.0)) continue;
            return r.getClas();
        }
        return this.defaultClass;
    }

    public double getAccuracy() {
        return this.fitness;
    }

    public void CBACBM2() {
        this.U = new ArrayList();
        this.Q = new ArrayList();
        this.A = new ArrayList();
        this.sort();
        this.stage1();
        this.stage2();
        this.stage3();
    }

    private boolean isNew(ArrayList<Rule> rb, Rule rule) {
        for (int i = 0; i < rb.size(); ++i) {
            Rule r = rb.get(i);
            if (!rule.isEqual(r)) continue;
            return false;
        }
        return true;
    }

    private void stage1() {
        this.U.clear();
        this.Q.clear();
        this.A.clear();
        for (int i = 0; i < this.train.size(); ++i) {
            Structure str;
            Rule rule;
            int[] example = this.train.getExample(i);
            int y = this.train.getOutputAsInteger(i);
            int cRule = -1;
            int wRule = -1;
            for (int j = 0; j < this.size() && (cRule < 0 || wRule < 0); ++j) {
                rule = this.ruleBase.get(j);
                if (!(rule.matching(example) > 0.0)) continue;
                if (cRule < 0 && y == rule.getClas()) {
                    cRule = j;
                }
                if (wRule >= 0 || y == rule.getClas()) continue;
                wRule = j;
            }
            if (cRule > -1) {
                rule = this.ruleBase.get(cRule);
                if (this.isNew(this.U, rule)) {
                    this.U.add(rule);
                }
                rule.incrCovered(y);
                if (cRule < wRule || wRule < 0) {
                    rule.onMark();
                    if (!this.isNew(this.Q, rule)) continue;
                    this.Q.add(rule);
                    continue;
                }
                str = new Structure(i, y, cRule, wRule);
                this.A.add(str);
                continue;
            }
            if (wRule <= -1) continue;
            str = new Structure(i, y, cRule, wRule);
            this.A.add(str);
        }
    }

    private void stage2() {
        for (int i = 0; i < this.A.size(); ++i) {
            Structure str = this.A.get(i);
            int poscRule = str.getcRule();
            int poswRule = str.getwRule();
            Rule wRule = this.ruleBase.get(poswRule);
            if (wRule.isMark()) {
                if (poscRule > -1) {
                    this.ruleBase.get(poscRule).decrCovered(str.gety());
                }
                wRule.incrCovered(str.gety());
                continue;
            }
            for (int j = 0; j < this.U.size(); ++j) {
                Rule rule = this.U.get(j);
                if (!(rule.matching(this.train.getExample(str.getdID())) > 0.0) || rule.getClas() == str.gety()) continue;
                if (poscRule > -1) {
                    Rule cRule = this.ruleBase.get(poscRule);
                    if (!rule.isPrecedence(cRule)) continue;
                    rule.addReplace(new Replace(poscRule, str.getdID(), str.gety()));
                    rule.incrCovered(str.gety());
                    if (!this.isNew(this.Q, rule)) continue;
                    this.Q.add(rule);
                    continue;
                }
                rule.addReplace(new Replace(poscRule, str.getdID(), str.gety()));
                rule.incrCovered(str.gety());
                if (!this.isNew(this.Q, rule)) continue;
                this.Q.add(rule);
            }
        }
    }

    private void stage3() {
        int i;
        this.C = new ArrayList();
        int[] compClassDistr = new int[this.train.getnClasses()];
        for (i = 0; i < this.train.getnClasses(); ++i) {
            compClassDistr[i] = this.train.numberInstances(i);
        }
        int ruleErrors = 0;
        int[] exampleCovered = new int[this.train.size()];
        for (i = 0; i < this.train.size(); ++i) {
            exampleCovered[i] = 0;
        }
        Collections.sort(this.Q);
        for (i = 0; i < this.Q.size(); ++i) {
            int j;
            Rule rule = this.Q.get(i);
            if (rule.getclassCasesCovered(rule.getClas()) <= 0) continue;
            for (j = 0; j < rule.getnReplace(); ++j) {
                Replace rep = rule.getReplace(j);
                if (exampleCovered[rep.getdID()] > 0) {
                    rule.decrCovered(rep.gety());
                    continue;
                }
                if (rep.getcRule() <= -1) continue;
                this.ruleBase.get(rep.getcRule()).decrCovered(rep.gety());
            }
            int errorsOfRule = 0;
            for (j = 0; j < this.train.size(); ++j) {
                int[] example;
                if (exampleCovered[j] >= 1 || !(rule.matching(example = this.train.getExample(j)) > 0.0)) continue;
                exampleCovered[j] = 1;
                int n = this.train.getOutputAsInteger(j);
                compClassDistr[n] = compClassDistr[n] - 1;
                if (rule.getClas() == this.train.getOutputAsInteger(j)) continue;
                ++errorsOfRule;
            }
            ruleErrors += errorsOfRule;
            int defaultClass = 0;
            for (j = 1; j < this.train.getnClasses(); ++j) {
                if (compClassDistr[defaultClass] >= compClassDistr[j]) continue;
                defaultClass = j;
            }
            int defaultErrors = 0;
            for (j = 0; j < this.train.getnClasses(); ++j) {
                if (j == defaultClass) continue;
                defaultErrors += compClassDistr[j];
            }
            int totalErrors = ruleErrors + defaultErrors;
            this.C.add(new Selected(rule, defaultClass, totalErrors));
        }
        if (this.C.size() > 0) {
            int lowestTotalErrors = this.C.get(0).getTotalErrors();
            int posLowest = 0;
            for (i = 1; i < this.C.size(); ++i) {
                Selected sel = this.C.get(i);
                if (sel.getTotalErrors() >= lowestTotalErrors) continue;
                lowestTotalErrors = sel.getTotalErrors();
                posLowest = i;
            }
            while (this.C.size() > posLowest + 1) {
                this.C.remove(posLowest + 1);
            }
        }
    }

    public RuleBase getClassifier() {
        RuleBase rb = new RuleBase(this.dataBase, this.train);
        if (this.C.size() > 0) {
            Selected sel;
            for (int i = 0; i < this.C.size(); ++i) {
                sel = this.C.get(i);
                rb.add(sel.getRule().clone());
            }
            sel = this.C.get(this.C.size() - 1);
            rb.setDefaultClass(sel.getDefaultClass());
        } else {
            int defaultClass = 0;
            for (int i = 1; i < this.train.getnClasses(); ++i) {
                if (this.train.numberInstances(i) <= this.train.numberInstances(defaultClass)) continue;
                defaultClass = i;
            }
            rb.setDefaultClass(defaultClass);
        }
        return rb;
    }

    public String printString() {
        int i;
        String[] names = this.train.names();
        String[] clases = this.train.clases();
        String stringOut = new String("");
        int ant = 0;
        for (i = 0; i < this.ruleBase.size(); ++i) {
            int j;
            Rule r = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            for (j = 0; j < this.n_variables && r.antecedent[j] < 0; ++j) {
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                ++ant;
            }
            ++j;
            while (j < this.n_variables - 1) {
                if (r.antecedent[j] >= 0) {
                    stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                    ++ant;
                }
                ++j;
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]) + ": " + clases[r.clas] + "\n";
                ++ant;
                continue;
            }
            stringOut = stringOut + ": " + clases[r.clas] + "\n";
        }
        stringOut = stringOut + "Default: " + clases[this.defaultClass] + "\n";
        stringOut = stringOut + "\n\n";
        stringOut = stringOut + "@supp and conf:\n\n";
        for (i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            stringOut = stringOut + "supp: " + rule.getSupport() + " AND conf: " + rule.getConfidence() + "\n";
        }
        stringOut = this.ruleBase.size() > 0 ? "@Number of rules: " + (this.ruleBase.size() + 1) + " Number of Antecedents by rule: " + (double)ant * 1.0 / (double)this.ruleBase.size() + "\n\n" + stringOut : "@Number of rules: 1 Number of Antecedents by rule: 0\n\n" + stringOut;
        return stringOut;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Fichero.escribeFichero(filename, stringOut);
    }
}

