/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.binarray.mut;

import net.sf.jclec.IConfigure;
import net.sf.jclec.binarray.BinArrayIndividual;
import net.sf.jclec.binarray.BinArrayMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniformMutator<I extends BinArrayIndividual>
extends BinArrayMutator<I>
implements IConfigure {
    private static final long serialVersionUID = 1709293115607625737L;
    private double locusMutationProb;

    public final double getLocusMutationProb() {
        return this.locusMutationProb;
    }

    public final void setLocusMutationProb(double mutProb) {
        this.locusMutationProb = mutProb;
    }

    @Override
    public void configure(Configuration configuration) {
        double locusMutationProb = configuration.getDouble("[@locus-mutation-prob]", 0.5);
        this.setLocusMutationProb(locusMutationProb);
    }

    public boolean equals(Object other) {
        if (other instanceof UniformMutator) {
            UniformMutator cother = (UniformMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusMutationProb, cother.locusMutationProb);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void mutateNext() {
        int gl = this.species.getGenotypeLength();
        BinArrayIndividual mutant = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        byte[] mgenome = new byte[gl];
        System.arraycopy(mutant.getGenotype(), 0, mgenome, 0, gl);
        int i = 0;
        while (i < gl) {
            if (this.randgen.coin(this.locusMutationProb)) {
                this.flip(mgenome, i);
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(mgenome));
    }
}

