/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.selector.DeterministicSelector;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorsesSelector<I extends IIndividual>
extends DeterministicSelector<I> {
    private static final long serialVersionUID = -697152908546090334L;
    protected transient Comparator<I> individualsComparator = new Comparator<I>(){

        @Override
        public int compare(I arg0, I arg1) {
            return WorsesSelector.this.fitnessComparator.compare(arg0.getFitness(), arg1.getFitness());
        }
    };
    protected transient Comparator<IFitness> fitnessComparator;
    protected transient ArrayList<I> auxList = new ArrayList();

    public WorsesSelector() {
    }

    public WorsesSelector(ISystem<I> context) {
        super(context);
    }

    public final void configure(Configuration settings) {
    }

    public boolean equals(Object other) {
        return other instanceof WorsesSelector;
    }

    @Override
    protected void prepareSelection() {
        this.auxList.clear();
        this.fitnessComparator = this.context.getEvaluator().getComparator();
        for (IIndividual ind : this.actsrc) {
            this.auxList.add(ind);
        }
    }

    @Override
    protected I selectNext() {
        if (this.auxList.isEmpty()) {
            this.prepareSelection();
        }
        IIndividual best = (IIndividual)Collections.min(this.auxList, this.individualsComparator);
        this.auxList.remove(best);
        return (I)best;
    }
}

