/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Ripper;

import java.util.Arrays;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.Ripper.Trio;
import keel.Algorithms.Rule_Learning.Ripper.Utilities;

public class Score {
    private Vector trios = new Vector();
    static int POSITIVE = 0;
    static int NEGATIVE = 1;

    public void addKey(double key) {
        Trio t = new Trio(key);
        this.trios.add(t);
    }

    public void addKey(double key, int sign) {
        Trio t = new Trio(key);
        if (sign == POSITIVE) {
            t.addPositive();
        } else if (sign == NEGATIVE) {
            t.addNegative();
        }
        this.trios.add(t);
    }

    public void addPositive(int pos) {
        ((Trio)this.trios.elementAt(pos)).addPositive();
    }

    public void addPositive(double key) {
        int pos = this.findKey(key);
        ((Trio)this.trios.elementAt(pos)).addPositive();
    }

    public void addNegative(int pos) {
        ((Trio)this.trios.elementAt(pos)).addNegative();
    }

    public void addNegative(double key) {
        int pos = this.findKey(key);
        ((Trio)this.trios.elementAt(pos)).addNegative();
    }

    public int findKey(double key) {
        int i;
        for (i = 0; i < this.trios.size() && ((Trio)this.trios.elementAt(i)).getKey() != key; ++i) {
        }
        if (i < this.trios.size()) {
            return i;
        }
        return -1;
    }

    public double getKey(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getKey();
    }

    public int getPositive(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public int getPositive(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public int getNegative(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getNegative();
    }

    public int getNegative(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getNegative();
    }

    public int getTotal(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getNegative() + ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public int getTotal(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getNegative() + ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public void sort() {
        if (this.trios.size() > 1) {
            Trio[] t = new Trio[this.trios.size()];
            this.trios.toArray(t);
            Utilities.mergeSort(t, this.trios.size());
            this.trios = new Vector<Trio>(Arrays.asList(t));
        }
    }

    public int size() {
        return this.trios.size();
    }

    public String toString() {
        String outcome = "";
        for (int i = 0; i < this.trios.size(); ++i) {
            outcome = outcome + (Trio)this.trios.elementAt(i) + "\n";
        }
        return outcome;
    }

    public String toString(int a) {
        String outcome = "";
        for (int i = 0; i < this.trios.size(); ++i) {
            outcome = outcome + ((Trio)this.trios.elementAt(i)).toString(a) + "\n";
        }
        return outcome;
    }
}

