/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.ICFLVQ3;

import java.util.StringTokenizer;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ3;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class ICFLVQ3
extends Metodo {
    private int k;
    private double semilla;
    public String Script;
    private PrototypeSet trainingDataSet;
    private PrototypeGenerator generador;
    private int Maxiter;
    private double alpha0;
    private double windowW;
    private double epsilon;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;

    public ICFLVQ3(String ficheroScript) {
        super(ficheroScript);
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public double classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = ICFLVQ3._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return 100.0 * ((double)wellClassificated / (double)test.size());
    }

    public void ejecutar() {
        boolean progresa;
        int j;
        int i;
        int nSel = 0;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean[] marcas = new boolean[this.datosTrain.length];
        int[] reachable = new int[this.datosTrain.length];
        int[] coverage = new int[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
            reachable[i] = 0;
            coverage[i] = 0;
        }
        nSel = this.datosTrain.length;
        double[] minDistEnemigo = new double[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            minDistEnemigo[i] = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.datosTrain.length; ++j) {
                double dist = KNN.distancia((double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (double[])this.datosTrain[j], (double[])this.realTrain[j], (int[])this.nominalTrain[j], (boolean[])this.nulosTrain[j], (boolean)this.distanceEu);
                if (this.clasesTrain[i] == this.clasesTrain[j] || !(dist < minDistEnemigo[i])) continue;
                minDistEnemigo[i] = dist;
            }
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            int claseObt = KNN.evaluacionKNN2((int)this.k, (double[][])this.datosTrain, (double[][])this.realTrain, (int[][])this.nominalTrain, (boolean[][])this.nulosTrain, (int[])this.clasesTrain, (double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (int)nClases, (boolean)this.distanceEu);
            if (claseObt == this.clasesTrain[i]) continue;
            marcas[i] = false;
            --nSel;
        }
        do {
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (!marcas[i]) continue;
                coverage[i] = this.getCoverage(i, marcas, minDistEnemigo);
                reachable[i] = this.getReachable(i, marcas, minDistEnemigo);
            }
            progresa = false;
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (!marcas[i] || reachable[i] <= coverage[i]) continue;
                marcas[i] = false;
                --nSel;
                progresa = true;
            }
        } while (progresa);
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (int m = 0; m < this.datosTrain.length; ++m) {
            if (!marcas[m]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[m][j];
                conjR[l][j] = this.realTrain[m][j];
                conjN[l][j] = this.nominalTrain[m][j];
                conjM[l][j] = this.nulosTrain[m][j];
            }
            clasesS[l] = this.clasesTrain[m];
            ++l;
        }
        System.out.println("ICF " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida((String)this.ficheroSalida[0], (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        OutputIS.escribeSalida((String)this.ficheroSalida[1], (InstanceSet)this.test, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        Parameters.assertBasicArgs(this.ficheroSalida);
        PrototypeGenerationAlgorithm.readParametersFile(this.Script);
        PrototypeGenerationAlgorithm.printParameters();
        PrototypeSet training = ICFLVQ3.readPrototypeSet(this.ficheroSalida[0]);
        this.trainingDataSet = ICFLVQ3.readPrototypeSet(this.ficheroTraining);
        this.generador = new PrototypeGenerator(this.trainingDataSet);
        double initialAcc = this.classficationAccuracy1NN(training, this.trainingDataSet);
        System.out.println("Initial Acc = " + initialAcc);
        PrototypeSet LVQ32 = this.makeLVQ3Reduction(training, this.trainingDataSet);
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(LVQ32);
        initialAcc = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        System.out.println("Final Acc = " + initialAcc);
        LVQ32.save(this.ficheroSalida[0]);
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate((double[])this.datosTrain[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[0], (int[][])trainRealClass, (int[][])trainPrediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate((double[])this.datosTest[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[1], (int[][])realClass, (int[][])prediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
    }

    private int getCoverage(int actual, boolean[] marcas, double[] minDistEnemigo) {
        int suma = 0;
        for (int i = 0; i < this.datosTrain.length; ++i) {
            int adap = 0;
            if (i != actual && marcas[i]) {
                adap = this.getAdaptable(actual, i, minDistEnemigo);
            }
            suma += adap;
        }
        return suma;
    }

    private int getReachable(int actual, boolean[] marcas, double[] minDistEnemigo) {
        int suma = 0;
        for (int i = 0; i < this.datosTrain.length; ++i) {
            int adap = 0;
            if (i != actual && marcas[i]) {
                adap = this.getAdaptable(i, actual, minDistEnemigo);
            }
            suma += adap;
        }
        return suma;
    }

    private int getAdaptable(int x, int y, double[] minDistEnemigo) {
        double dist = KNN.distancia((double[])this.datosTrain[x], (double[])this.realTrain[x], (int[])this.nominalTrain[x], (boolean[])this.nulosTrain[x], (double[])this.datosTrain[y], (double[])this.realTrain[y], (int[])this.nominalTrain[y], (boolean[])this.nulosTrain[y], (boolean)this.distanceEu);
        if (dist < minDistEnemigo[x]) {
            return 1;
        }
        return 0;
    }

    private PrototypeSet makeLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training) {
        int size = InitialSet.size();
        LVQ3 lvq3 = new LVQ3(InitialSet, training, this.Maxiter, size, this.alpha0, this.windowW, this.epsilon);
        PrototypeSet reducedByLVQ3 = lvq3.reduceSet();
        return reducedByLVQ3;
    }

    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.Maxiter = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.alpha0 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.windowW = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.epsilon = Double.parseDouble(tokens.nextToken().substring(1));
        System.out.print("\nIsaac dice:   alpha0= " + this.alpha0 + " Maxiter= " + this.Maxiter + " epsilon=  " + this.epsilon + "\n");
    }
}

