/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.OBDE;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class OBDEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double CrossOverRate;
    private double JumpingRate;
    private int Strategy;
    private String CrossoverType;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;

    public OBDEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, double JR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "OBDE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.ScalingFactor = F;
        this.CrossOverRate = CR;
        this.JumpingRate = JR;
        this.Strategy = strg;
    }

    public OBDEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "OBDE";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.ScalingFactor = parameters.getNextAsDouble();
        this.CrossOverRate = parameters.getNextAsDouble();
        this.JumpingRate = parameters.getNextAsDouble();
        this.Strategy = parameters.getNextAsInt();
        this.CrossoverType = parameters.getNextAsString();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        System.out.print("\nIsaac dice:  JR= " + this.JumpingRate + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " CR=  " + this.CrossOverRate + "\n");
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int mejor) {
        PrototypeSet mutant = new PrototypeSet(population.length);
        int[] lista = new int[population.length];
        this.inic_vector_sin(lista, actual);
        this.desordenar_vector_sin(lista);
        PrototypeSet r1 = population[lista[0]];
        PrototypeSet r2 = population[lista[1]];
        PrototypeSet r3 = population[lista[2]];
        PrototypeSet r4 = population[lista[3]];
        PrototypeSet r5 = population[lista[4]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = producto.sumar(resta);
                break;
            }
            case 2: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                mutant = population[mejor].sumar(producto);
                break;
            }
            case 3: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 4: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[mejor].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 5: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet resta2 = r4.restar(r5);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = r1.sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 6: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet resta3 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet producto3 = resta3.mulEscalar(this.ScalingFactor);
                PrototypeSet result = population[actual].sumar(producto);
                result = result.sumar(producto2);
                mutant = result.sumar(producto3);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    public int[] mejoresParticulas(PrototypeSet[] population) {
        double acc;
        int number = this.PopulationSize;
        int[] index = new int[number];
        int ind = 0;
        double mejor = Double.MIN_VALUE;
        for (int i = 0; i < population.length; ++i) {
            acc = OBDEGenerator.accuracy(population[i], this.trainingDataSet);
            if (!(acc > mejor)) continue;
            ind = i;
            mejor = acc;
        }
        index[0] = ind;
        for (int j = 1; j < number; ++j) {
            mejor = Double.MIN_VALUE;
            for (int i = 0; i < population.length; ++i) {
                acc = OBDEGenerator.accuracy(population[i], this.trainingDataSet);
                if (!(acc > mejor) || !(acc < OBDEGenerator.accuracy(population[index[j - 1]], this.trainingDataSet))) continue;
                ind = i;
                mejor = acc;
            }
            index[j] = ind;
        }
        return index;
    }

    @Override
    public PrototypeSet reduceSet() {
        int i;
        System.out.print("\nThe algorithm  DE is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        if (this.numberOfPrototypes < 6) {
            System.out.println("Number of prototypes less than 6, we increse to 6");
            this.numberOfPrototypes = 6;
        }
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] populationAux = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        populationAux[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        fitness[0] = OBDEGenerator.accuracy(populationAux[0], this.trainingDataSet);
        for (int i2 = 1; i2 < this.PopulationSize; ++i2) {
            populationAux[i2] = new PrototypeSet();
            for (int j = 0; j < populationAux[0].size(); ++j) {
                populationAux[i2].add(this.trainingDataSet.getFromClass(((Prototype)populationAux[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i2] = OBDEGenerator.accuracy(populationAux[i2], this.trainingDataSet);
        }
        PrototypeSet[] opposite = new PrototypeSet[this.PopulationSize];
        for (int i3 = 0; i3 < populationAux.length; ++i3) {
            opposite[i3] = populationAux[i3].clone();
            for (int j = 0; j < opposite[i3].size(); ++j) {
                for (int k = 0; k < ((Prototype)opposite[i3].get(j)).numberOfInputs(); ++k) {
                    double valor = 1.0 - ((Prototype)opposite[i3].get(j)).getInput(k);
                    ((Prototype)opposite[i3].get(j)).setInput(k, valor);
                }
                opposite[i3].applyThresholds();
                Prototype Nearest = KNN._1nn((Prototype)opposite[i3].get(j), this.trainingDataSet);
                ((Prototype)opposite[i3].get(j)).setClass(Nearest.getOutput(0));
            }
        }
        PrototypeSet[] PopulationOpposite = new PrototypeSet[this.PopulationSize * 2];
        for (int i4 = 0; i4 < population.length; ++i4) {
            PopulationOpposite[i4] = populationAux[i4].clone();
            PopulationOpposite[i4 + populationAux.length] = opposite[i4].clone();
        }
        int[] indices = this.mejoresParticulas(PopulationOpposite);
        for (int i5 = 0; i5 < indices.length; ++i5) {
            population[i5] = PopulationOpposite[indices[i5]].clone();
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i6 = 1; i6 < this.PopulationSize; ++i6) {
            if (!(fitness[i6] > bestFitness)) continue;
            bestFitness = fitness[i6];
            bestFitnessIndex = i6;
        }
        for (int j = 0; j < this.PopulationSize; ++j) {
            for (i = 0; i < population[j].size(); ++i) {
                ((Prototype)population[j].get(i)).setIndex(i);
            }
        }
        boolean[] cruceExp = new boolean[this.PopulationSize];
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int j;
            int i7;
            int i8;
            if (this.CrossoverType.equals("Exponential")) {
                for (i8 = 0; i8 < this.PopulationSize; ++i8) {
                    cruceExp[i8] = false;
                }
            }
            for (i8 = 0; i8 < this.PopulationSize; ++i8) {
                mutation[i8] = new PrototypeSet(population[i8].size());
                mutation[i8] = this.mutant(population, i8, bestFitnessIndex).clone();
                crossover[i8] = new PrototypeSet(population[i8]);
                for (int j2 = 0; j2 < population[i8].size(); ++j2) {
                    if (this.CrossoverType.equals("Binomial")) {
                        double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                        if (!(randNumber < this.CrossOverRate)) continue;
                        crossover[i8].set(j2, mutation[i8].get(j2));
                        continue;
                    }
                    if (this.CrossoverType.equals("Exponential")) {
                        int startingPoint = RandomGenerator.Randint(0, this.PopulationSize);
                        int L = 0;
                        while (RandomGenerator.Randdouble(0.0, 1.0) < this.CrossOverRate && ++L < population[i8].size()) {
                        }
                        for (int m = startingPoint; m < startingPoint + L; ++m) {
                            crossover[i8].set(m % population[i8].size(), mutation[i8].get(j2));
                        }
                        continue;
                    }
                    if (this.CrossoverType.equals("Arithmetic")) {
                        PrototypeSet resta = mutation[i8].restar(population[i8]);
                        crossover[i8] = population[i8].sumar(resta.mulEscalar(RandomGenerator.Randdouble(0.0, 1.0)));
                        continue;
                    }
                    System.err.println("ERROR, Crossover Type incorrect.");
                }
                double trialVector = OBDEGenerator.accuracy(crossover[i8], this.trainingDataSet);
                fitness[i8] = OBDEGenerator.accuracy(population[i8], this.trainingDataSet);
                if (trialVector > fitness[i8]) {
                    population[i8] = crossover[i8].clone();
                }
                fitness[i8] = OBDEGenerator.accuracy(population[i8], this.trainingDataSet);
                if (!(fitness[i8] > bestFitness)) continue;
                bestFitness = fitness[i8];
                bestFitnessIndex = i8;
            }
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < this.JumpingRate)) continue;
            populationAux = new PrototypeSet[this.PopulationSize];
            populationAux = (PrototypeSet[])population.clone();
            double[][] min = new double[population[0].size()][((Prototype)opposite[0].get(0)).numberOfInputs()];
            double[][] max = new double[population[0].size()][((Prototype)opposite[0].get(0)).numberOfInputs()];
            for (i7 = 0; i7 < population[0].size(); ++i7) {
                for (j = 0; j < ((Prototype)opposite[0].get(0)).numberOfInputs(); ++j) {
                    min[i7][j] = 1.0;
                    max[i7][j] = 0.0;
                }
            }
            for (i7 = 0; i7 < population.length; ++i7) {
                for (j = 0; j < population[i7].size(); ++j) {
                    for (int k = 0; k < ((Prototype)population[i7].get(j)).numberOfInputs(); ++k) {
                        if (((Prototype)population[i7].get(j)).getInput(k) < min[j][k]) {
                            min[j][k] = ((Prototype)population[i7].get(j)).getInput(k);
                        }
                        if (!(((Prototype)population[i7].get(j)).getInput(k) > max[j][k])) continue;
                        max[j][k] = ((Prototype)population[i7].get(j)).getInput(k);
                    }
                }
            }
            for (i7 = 0; i7 < populationAux.length; ++i7) {
                opposite[i7] = populationAux[i7].clone();
                for (j = 0; j < opposite[i7].size(); ++j) {
                    for (int k = 0; k < ((Prototype)opposite[i7].get(j)).numberOfInputs(); ++k) {
                        double valor = min[j][k] + max[j][k] - ((Prototype)opposite[i7].get(j)).getInput(k);
                        ((Prototype)opposite[i7].get(j)).setInput(k, valor);
                    }
                    opposite[i7].applyThresholds();
                    Prototype Nearest = KNN._1nn((Prototype)opposite[i7].get(j), this.trainingDataSet);
                    ((Prototype)opposite[i7].get(j)).setClass(Nearest.getOutput(0));
                }
            }
            PopulationOpposite = new PrototypeSet[this.PopulationSize * 2];
            for (i7 = 0; i7 < population.length; ++i7) {
                PopulationOpposite[i7] = populationAux[i7].clone();
                PopulationOpposite[i7 + populationAux.length] = opposite[i7].clone();
            }
            indices = this.mejoresParticulas(PopulationOpposite);
            for (i7 = 0; i7 < indices.length; ++i7) {
                population[i7] = PopulationOpposite[indices[i7]].clone();
            }
        }
        bestFitness = 0.0;
        bestFitnessIndex = 0;
        for (i = 0; i < this.PopulationSize; ++i) {
            if (!(fitness[i] > bestFitness)) continue;
            bestFitness = fitness[i];
            bestFitnessIndex = i;
        }
        System.err.println("\n% de acierto en training " + (double)KNN.classficationAccuracy(population[bestFitnessIndex], this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return population[bestFitnessIndex];
    }

    public static void main(String[] args) {
        Parameters.setUse("OBDE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        OBDEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        OBDEGenerator generator = new OBDEGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 0.3, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

