/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.AdaBoost;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.AdaBoostMaxMin;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyClassifier;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.LogitBoost;
import org.core.Randomize;

public class FB {
    static double[][] W;
    static Randomize r;
    static double[][] train;
    static int[] ctrain;
    static int nfeatures;
    static int nclases;
    static double[][] test;
    static int[] ctest;
    static double[][] f;
    static int[] c;

    public static void fuzzycreavacio(int nentradas, int nsalidas, int nlabels, double[] train, double[] ytrain, double[] bancoreglas, Randomize vr) {
        r = vr;
        int nelem = train.length / nentradas;
        System.out.println("Numero entradas=" + nentradas);
        System.out.println("Numero salidas=" + nsalidas);
        System.out.println("Dimension train=" + train.length);
        System.out.println("Dimension ytrain=" + ytrain.length);
        System.out.println("Dimension bancoreglas=" + bancoreglas.length);
        System.out.println("Numero ejemplos=" + nelem);
        System.out.println("Numero de etiquetas por variable=" + nlabels);
        double errf = 0.0;
        double[][] ejemplos = new double[nelem][nentradas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nentradas; ++j) {
                ejemplos[i][j] = train[i * nentradas + j];
            }
        }
        double[][] deseado = new double[nelem][nsalidas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nsalidas; ++j) {
                deseado[i][j] = ytrain[i + j * nelem];
            }
        }
        FuzzyClassifier cf = new FuzzyClassifier(ejemplos, deseado);
        cf.EstimaParticiones(nlabels);
        cf.AlmacenaParametros(bancoreglas);
    }

    public static double[] fuzzyclasifica(double[] x, int nsalidas, double[] bancoreglas) {
        double[][] ejemplos = new double[][]{x};
        double[][] deseado = new double[1][nsalidas];
        FuzzyClassifier cf = new FuzzyClassifier(ejemplos, deseado);
        cf.RecuperaParametros(bancoreglas);
        double[][][] Mu = new double[1][cf.Etiquetas.length][];
        for (int i = 0; i < cf.nelem; ++i) {
            for (int v = 0; v < cf.Etiquetas.length; ++v) {
                Mu[i][v] = cf.Etiquetas[v].pertenencia(cf.ejemplos[i][v]);
            }
        }
        double[] suma = new double[nsalidas];
        for (int r = 0; r < cf.BaseConocimiento.length; ++r) {
            double tr = cf.CertezaAntecedenteEj(0, cf.BaseConocimiento[r], Mu);
            for (int k = 0; k < nsalidas; ++k) {
                int n = k;
                suma[n] = suma[n] + cf.BaseConocimiento[r].consecuente[k] * tr;
            }
        }
        return suma;
    }

    public static double[] fuzzyclasificamaxmin(double[] x, int nsalidas, double[] bancoreglas) {
        double[][] ejemplos = new double[][]{x};
        double[][] deseado = new double[1][nsalidas];
        AdaBoostMaxMin cf = new AdaBoostMaxMin(ejemplos, deseado, r);
        cf.RecuperaParametros(bancoreglas);
        double[][][] Mu = new double[1][cf.Etiquetas.length][];
        for (int i = 0; i < cf.nelem; ++i) {
            for (int v = 0; v < cf.Etiquetas.length; ++v) {
                Mu[i][v] = cf.Etiquetas[v].pertenencia(cf.ejemplos[i][v]);
            }
        }
        double[] maximos = new double[nsalidas];
        double[] W = new double[1];
        int cmax = cf.fuzzyclasificamaxmin(0, Mu, W);
        maximos[cmax] = W[0];
        return maximos;
    }

    public static void fadaboostinc(int nentradas, int nsalidas, double[] train, double[] ytrain, double[] bancoreglas) {
        int nelem = train.length / nentradas;
        System.out.println("Numero entradas=" + nentradas);
        System.out.println("Numero salidas=" + nsalidas);
        System.out.println("Dimension train=" + train.length);
        System.out.println("Dimension ytrain=" + ytrain.length);
        System.out.println("Dimension bancoreglas=" + bancoreglas.length);
        System.out.println("Numero ejemplos=" + nelem);
        double errf = 0.0;
        double[][] ejemplos = new double[nelem][nentradas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nentradas; ++j) {
                ejemplos[i][j] = train[i * nentradas + j];
            }
        }
        double[][] deseado = new double[nelem][nsalidas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nsalidas; ++j) {
                deseado[i][j] = ytrain[i + j * nelem];
            }
        }
        AdaBoost cf = new AdaBoost(ejemplos, deseado, r);
        cf.RecuperaParametros(bancoreglas);
        double[][][] Mu = new double[cf.nelem][cf.Etiquetas.length][];
        for (int i = 0; i < cf.nelem; ++i) {
            for (int v = 0; v < cf.Etiquetas.length; ++v) {
                Mu[i][v] = cf.Etiquetas[v].pertenencia(cf.ejemplos[i][v]);
            }
        }
        W = new double[nsalidas][nelem];
        int limite = nsalidas;
        if (limite == 2) {
            limite = 1;
        }
        int Clase = -1;
        double maxerr = 0.0;
        double[] total = new double[nsalidas];
        for (int r = 0; r < cf.BaseConocimiento.length; ++r) {
            int n = cf.argmaxabs(cf.BaseConocimiento[r].consecuente);
            total[n] = total[n] + 1.0;
        }
        Clase = FB.argmin(total);
        if (nsalidas == 2) {
            Clase = 0;
        }
        System.out.println("PROCESANDO CLASE " + Clase);
        double[] dsigno = cf.CalculaSignoDeseado(Clase);
        cf.CalculaPesosEjemplosABD(W[Clase], Clase, Mu, dsigno);
        cf.AnadeReglaABD2C(Clase, Mu, W[Clase], dsigno);
        cf.AlmacenaParametros(bancoreglas);
        cf.MuestraBase();
    }

    public static void flogitboostinc(int nentradas, int nsalidas, double[] train, double[] ytrain, double[] bancoreglas, boolean VB) {
        int nelem = train.length / nentradas;
        System.out.println("Numero entradas=" + nentradas);
        System.out.println("Numero salidas=" + nsalidas);
        System.out.println("Dimension train=" + train.length);
        System.out.println("Dimension ytrain=" + ytrain.length);
        System.out.println("Dimension bancoreglas=" + bancoreglas.length);
        System.out.println("Numero ejemplos=" + nelem);
        double errf = 0.0;
        double[][] ejemplos = new double[nelem][nentradas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nentradas; ++j) {
                ejemplos[i][j] = train[i * nentradas + j];
            }
        }
        double[][] deseado = new double[nelem][nsalidas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nsalidas; ++j) {
                deseado[i][j] = ytrain[i + j * nelem];
            }
        }
        LogitBoost cf = new LogitBoost(ejemplos, deseado, VB, r);
        cf.RecuperaParametros(bancoreglas);
        double[][][] Mu = new double[cf.nelem][cf.Etiquetas.length][];
        for (int i = 0; i < cf.nelem; ++i) {
            for (int v = 0; v < cf.Etiquetas.length; ++v) {
                Mu[i][v] = cf.Etiquetas[v].pertenencia(cf.ejemplos[i][v]);
            }
        }
        W = new double[nsalidas][nelem];
        int limite = nsalidas;
        if (limite == 2) {
            limite = 1;
        }
        int Clase = -1;
        double maxerr = 0.0;
        double[] total = new double[nsalidas];
        for (int r = 0; r < cf.BaseConocimiento.length; ++r) {
            int n = cf.argmaxabs(cf.BaseConocimiento[r].consecuente);
            total[n] = total[n] + 1.0;
        }
        Clase = FB.argmin(total);
        if (nsalidas == 2) {
            Clase = 0;
        }
        System.out.println("PROCESANDO CLASE " + Clase);
        double[] dsigno = cf.CalculaSignoDeseado(Clase);
        cf.AnadeReglaLGB2C(Clase, Mu, W[Clase], dsigno);
        cf.AlmacenaParametros(bancoreglas);
        cf.MuestraBase();
    }

    public static void fadaboostincmaxmin(int nentradas, int nsalidas, double[] train, double[] ytrain, double[] bancoreglas, double[] oldfit) {
        int nelem = train.length / nentradas;
        System.out.println("Numero entradas=" + nentradas);
        System.out.println("Numero salidas=" + nsalidas);
        System.out.println("Dimension train=" + train.length);
        System.out.println("Dimension ytrain=" + ytrain.length);
        System.out.println("Dimension bancoreglas=" + bancoreglas.length);
        System.out.println("Numero ejemplos=" + nelem);
        double errf = 0.0;
        double[][] ejemplos = new double[nelem][nentradas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nentradas; ++j) {
                ejemplos[i][j] = train[i * nentradas + j];
            }
        }
        double[][] deseado = new double[nelem][nsalidas];
        for (int i = 0; i < nelem; ++i) {
            for (int j = 0; j < nsalidas; ++j) {
                deseado[i][j] = ytrain[i + j * nelem];
            }
        }
        AdaBoostMaxMin cf = new AdaBoostMaxMin(ejemplos, deseado, r);
        cf.RecuperaParametros(bancoreglas);
        double[][][] Mu = new double[cf.nelem][cf.Etiquetas.length][];
        for (int i = 0; i < cf.nelem; ++i) {
            for (int v = 0; v < cf.Etiquetas.length; ++v) {
                Mu[i][v] = cf.Etiquetas[v].pertenencia(cf.ejemplos[i][v]);
            }
        }
        double newfit = cf.AnadeReglaABDMM(Mu);
        if (oldfit[0] > 0.0 && newfit >= oldfit[0]) {
            System.out.println("No se almacena la regla!");
            return;
        }
        cf.AlmacenaParametros(bancoreglas);
        cf.MuestraBase();
        oldfit[0] = newfit;
    }

    private static void CargaDatosClasifGranada(String nombre) {
        nclases = 1;
        try {
            BufferedReader in = new BufferedReader(new FileReader(nombre));
            String linea = in.readLine();
            int nejemplos = Integer.parseInt(linea);
            linea = in.readLine();
            nfeatures = Integer.parseInt(linea) - 1;
            f = new double[nejemplos][nfeatures];
            c = new int[nejemplos];
            for (int i = 0; i < nejemplos && (linea = in.readLine()) != null; ++i) {
                StringTokenizer tokens = new StringTokenizer(linea, " ,");
                for (int j = 0; j < nfeatures; ++j) {
                    FB.f[i][j] = Double.parseDouble(tokens.nextToken());
                }
                FB.c[i] = Integer.parseInt(tokens.nextToken());
                if (c[i] + 1 <= nclases) continue;
                nclases = c[i] + 1;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Fichero " + nombre + " no encontrado");
        }
        catch (IOException e) {
            System.err.println(e + " Error lectura");
        }
    }

    public static int argmax(double[] x) {
        double max = x[0];
        int imax = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
            imax = i;
        }
        return imax;
    }

    private static int argmin(double[] x) {
        double min = x[0];
        int imin = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
            imin = i;
        }
        return imin;
    }

    public static void main(String[] argv) {
        int j;
        int i;
        if (argv.length == 0) {
            System.out.println("Falta fichero de train");
            System.exit(1);
        }
        if (argv.length == 1) {
            System.out.println("Falta fichero de test");
            System.exit(1);
        }
        if (argv.length == 2) {
            System.out.println("Falta numero de reglas");
            System.exit(1);
        }
        if (argv.length == 3) {
            System.out.println("Falta numero de etiquetas");
            System.exit(1);
        }
        FB.CargaDatosClasifGranada(argv[0]);
        train = f;
        ctrain = c;
        FB.CargaDatosClasifGranada(argv[1]);
        test = f;
        ctest = c;
        int nreglas = Integer.parseInt(argv[2]);
        int nlabels = Integer.parseInt(argv[3]);
        double[] bancoreglas = new double[2000];
        int nentradas = nfeatures;
        int nsalidas = nclases;
        double[][] ytrain = new double[train.length][nsalidas];
        double[][] ytest = new double[test.length][nsalidas];
        for (i = 0; i < ytrain.length; ++i) {
            ytrain[i][FB.ctrain[i]] = 1.0;
        }
        for (i = 0; i < ytest.length; ++i) {
            ytest[i][FB.ctest[i]] = 1.0;
        }
        int p = 0;
        double[] lintrain = new double[train.length * train[0].length];
        for (int i2 = 0; i2 < train.length; ++i2) {
            for (int j2 = 0; j2 < train[i2].length; ++j2) {
                lintrain[p++] = train[i2][j2];
            }
        }
        p = 0;
        double[] lintest = new double[test.length * test[0].length];
        for (int i3 = 0; i3 < test.length; ++i3) {
            for (j = 0; j < test[i3].length; ++j) {
                lintest[p++] = test[i3][j];
            }
        }
        p = 0;
        double[] linytrain = new double[ytrain.length * ytrain[0].length];
        for (j = 0; j < ytrain[0].length; ++j) {
            for (int i4 = 0; i4 < ytrain.length; ++i4) {
                linytrain[p++] = ytrain[i4][j];
            }
        }
        p = 0;
        double[] linytest = new double[ytest.length * ytest[0].length];
        for (int j3 = 0; j3 < ytest[0].length; ++j3) {
            for (int i5 = 0; i5 < ytest.length; ++i5) {
                linytest[p++] = ytest[i5][j3];
            }
        }
        FB fb = new FB();
        double fallos = 0.0;
        FB.fuzzycreavacio(nentradas, nsalidas, nlabels, lintrain, linytrain, bancoreglas, r);
        int limite = 0;
        limite = nsalidas == 2 ? 1 : nsalidas;
        double[] fit = new double[1];
        for (int r = 0; r < nreglas; ++r) {
            double[] segs;
            int i6;
            fallos = 0.0;
            FB.fadaboostincmaxmin(nentradas, nsalidas, lintrain, linytrain, bancoreglas, fit);
            for (i6 = 0; i6 < train.length; ++i6) {
                segs = FB.fuzzyclasificamaxmin(train[i6], nsalidas, bancoreglas);
                for (int k = 0; k < segs.length; ++k) {
                    System.out.print(segs[k] + " ");
                }
                System.out.print("Clase=" + ctrain[i6]);
                int ac = FB.argmax(segs);
                if (ac != ctrain[i6]) {
                    fallos += 1.0;
                    System.out.println(" Fallo");
                    continue;
                }
                System.out.println(" Acierto");
            }
            System.out.println("Error Train: =" + fallos / (double)train.length);
            fallos = 0.0;
            for (i6 = 0; i6 < test.length; ++i6) {
                segs = FB.fuzzyclasificamaxmin(test[i6], nsalidas, bancoreglas);
                if (FB.argmax(segs) == ctest[i6]) continue;
                fallos += 1.0;
            }
            System.out.println("Test completo: " + fallos / (double)test.length);
        }
    }
}

