/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Javolution;
import javolution.lang.MathLib;
import javolution.lang.Text;
import javolution.realtime.PoolContext;

final class Perf_Lang
extends Javolution
implements Runnable {
    private static final int COUNT = 1000;
    private final String STRING = "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
    private final Text TEXT = Text.valueOf("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
    private final Text ONE_CHAR = Text.valueOf('X');

    Perf_Lang() {
    }

    public void run() {
        int n;
        int n2;
        CharSequence charSequence;
        int n3;
        Perf_Lang.println("//////////////////////////////");
        Perf_Lang.println("// Package: javolution.lang //");
        Perf_Lang.println("//////////////////////////////");
        Perf_Lang.println("");
        Perf_Lang.println("-- String/StringBuffer versus Text --");
        Perf_Lang.println("");
        Perf_Lang.println("\"Concatenates this line 1000 times (resulting in a text of about 80,000 characters)\"");
        Perf_Lang.print("String \"+\" operator: ");
        Perf_Lang.startTime();
        String string = "";
        for (n3 = 0; n3 < 1000; ++n3) {
            string = string + "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
        }
        Perf_Lang.println(Perf_Lang.endTime(1));
        Perf_Lang.print("StringBuffer \"append\" : ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer();
            for (n2 = 0; n2 < 1000; ++n2) {
                ((StringBuffer)charSequence).append("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text \"concat\" (heap): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.EMPTY;
            for (n2 = 0; n2 < 1000; ++n2) {
                charSequence = ((Text)charSequence).concat(this.TEXT);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text \"concat\" (stack): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.EMPTY;
            for (n2 = 0; n2 < 1000; ++n2) {
                charSequence = ((Text)charSequence).concat(this.TEXT);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
        Perf_Lang.println("Inserts one character at random locations 1,000 times to the 80,000 characters text.");
        Perf_Lang.print("StringBuffer insert: ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer(string);
            for (n2 = 1; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((StringBuffer)charSequence).length());
                ((StringBuffer)charSequence).insert(n, 'X');
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text insert (heap): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.valueOf(string);
            for (n2 = 1; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((Text)charSequence).length());
                charSequence = ((Text)charSequence).insert(n, this.ONE_CHAR);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text insert (stack): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.valueOf(string);
            for (n2 = 1; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((Text)charSequence).length());
                charSequence = ((Text)charSequence).insert(n, this.ONE_CHAR);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
        Perf_Lang.println("Delete 1,000 times one character at random location from the 80,000 characters text.");
        Perf_Lang.print("StringBuffer delete: ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer(string);
            for (n2 = 0; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((StringBuffer)charSequence).length() - 1);
                ((StringBuffer)charSequence).deleteCharAt(n);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text delete (heap): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.valueOf(string);
            for (n2 = 0; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((Text)charSequence).length() - 1);
                charSequence = ((Text)charSequence).delete(n, n + 1);
            }
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.print("Text delete (stack): ");
        Perf_Lang.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.valueOf(string);
            for (n2 = 0; n2 < 1000; ++n2) {
                n = MathLib.randomInt(0, ((Text)charSequence).length() - 1);
                charSequence = ((Text)charSequence).delete(n, n + 1);
            }
            PoolContext.exit();
        }
        Perf_Lang.println(Perf_Lang.endTime(100));
        Perf_Lang.println("");
    }
}

