/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.Globals.FileManagement;
import keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter.C45;
import keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter.Parameters;
import keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter.PartitionScheme;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class IterativePartitioningFilter {
    private Instance[] instancesTrain;
    private boolean[][] correctlyLabeled;
    private PartitionScheme partSch;
    private Vector noisyInstances;
    private int numFilters = Parameters.numPartitions;

    public IterativePartitioningFilter() {
        Randomize.setSeed(Parameters.seed);
        InstanceSet is = new InstanceSet();
        try {
            is.readSet(Parameters.trainInputFile, true);
        }
        catch (Exception e) {
            System.exit(1);
        }
        this.instancesTrain = is.getInstances();
        Parameters.numClasses = Attributes.getOutputAttribute(0).getNumNominalValues();
        Parameters.numAttributes = Attributes.getInputAttributes().length;
        Parameters.numInstances = this.instancesTrain.length;
    }

    public void run() {
        File fi;
        boolean stop = false;
        int countToStop = 0;
        int iter = 0;
        this.partSch = new PartitionScheme(Parameters.trainInputFile, Parameters.numPartitions);
        Instance[] insAux = this.partSch.getInstances();
        this.partSch.createPartitionFiles();
        this.noisyInstances = new Vector();
        this.createDatasetTrain(Parameters.trainInputFile, "IPF_train_0.txt");
        while (!stop) {
            this.correctlyLabeled = new boolean[this.numFilters][insAux.length];
            for (int i = 0; i < this.numFilters; ++i) {
                for (int j = 0; j < insAux.length; ++j) {
                    this.correctlyLabeled[i][j] = true;
                }
            }
            for (int k = 0; k < Parameters.numPartitions; ++k) {
                C45 c45 = null;
                try {
                    c45 = new C45("train" + (k + 1) + ".dat", "IPF_train_" + iter + ".txt");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int[] pre = c45.getPredictions();
                for (int i = 0; i < insAux.length; ++i) {
                    this.correctlyLabeled[k][i] = pre[i] == insAux[i].getOutputNominalValuesInt(0);
                }
            }
            this.noisyInstances = new Vector();
            if (Parameters.filterType.equals("consensus")) {
                for (int j = 0; j < insAux.length; ++j) {
                    boolean ruido = true;
                    for (int i = 0; i < this.numFilters && ruido; ++i) {
                        if (!this.correctlyLabeled[i][j]) continue;
                        ruido = false;
                    }
                    if (!ruido || this.correctlyLabeled[this.partSch.getPartitionOfInstance(j)][j]) continue;
                    this.noisyInstances.add(j);
                }
            }
            if (Parameters.filterType.equals("majority")) {
                for (int j = 0; j < insAux.length; ++j) {
                    int cont = 0;
                    for (int i = 0; i < this.numFilters; ++i) {
                        if (this.correctlyLabeled[i][j]) continue;
                        ++cont;
                    }
                    if (!((double)cont > (double)this.numFilters / 2.0) || this.correctlyLabeled[this.partSch.getPartitionOfInstance(j)][j]) continue;
                    this.noisyInstances.add(j);
                }
            }
            this.createDatasetTrain("IPF_train_" + iter + ".txt", "IPF_train_" + (iter + 1) + ".txt");
            this.partSch.deletePartitionFiles();
            fi = new File("IPF_train_" + iter + ".txt");
            fi.delete();
            countToStop = (double)this.noisyInstances.size() < (double)Parameters.numInstances * 0.01 ? ++countToStop : 0;
            if (countToStop == 3) {
                stop = true;
            } else {
                this.partSch = new PartitionScheme("IPF_train_" + (iter + 1) + ".txt", Parameters.numPartitions);
                insAux = this.partSch.getInstances();
                this.partSch.createPartitionFiles();
            }
            ++iter;
        }
        this.createDatasets("IPF_train_" + iter + ".txt", Parameters.trainOutputFile, Parameters.testInputFile, Parameters.testOutputFile);
        fi = new File("IPF_train_" + iter + ".txt");
        fi.delete();
    }

    public void createDatasets(String trainIN, String trainOUT, String testIN, String testOUT) {
        String s;
        PrintWriter out;
        BufferedReader in;
        File Archi2;
        File Archi1;
        try {
            Archi1 = new File(trainIN);
            Archi2 = new File(trainOUT);
            in = new BufferedReader(new FileReader(Archi1));
            out = new PrintWriter(new FileWriter(Archi2));
            while ((s = in.readLine()) != null) {
                out.println(s);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Archi1 = new File(testIN);
            Archi2 = new File(testOUT);
            in = new BufferedReader(new FileReader(Archi1));
            out = new PrintWriter(new FileWriter(Archi2));
            while ((s = in.readLine()) != null) {
                out.println(s);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDatasetTrain(String trainIN, String trainOUT) {
        int i;
        if (this.noisyInstances.size() > 0) {
            int menor = (Integer)this.noisyInstances.get(0);
            boolean correcto = true;
            for (int i2 = 1; i2 < this.noisyInstances.size() && correcto; ++i2) {
                if ((Integer)this.noisyInstances.get(i2) <= menor) {
                    correcto = false;
                    continue;
                }
                menor = (Integer)this.noisyInstances.get(i2);
            }
            if (!correcto) {
                System.out.println("\n\nERROR: The noisy vector is not ordered!");
                System.exit(-1);
            }
        }
        InstanceSet is = new InstanceSet();
        Instance[] instances = null;
        try {
            is.readSet(trainIN, false);
            instances = is.getInstances();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int numAtt = Attributes.getInputNumAttributes();
        Vector<Integer> validInstances = new Vector<Integer>();
        int cont = 0;
        if (this.noisyInstances.size() == 0) {
            for (i = 0; i < instances.length; ++i) {
                validInstances.add(i);
            }
        } else {
            for (i = 0; i < instances.length; ++i) {
                if (cont < this.noisyInstances.size() && (Integer)this.noisyInstances.get(cont) == i) {
                    ++cont;
                    continue;
                }
                validInstances.add(i);
            }
        }
        String header = "";
        header = "@relation " + Attributes.getRelationName() + "\n";
        header = header + Attributes.getInputAttributesHeader();
        header = header + Attributes.getOutputAttributesHeader();
        header = header + Attributes.getInputHeader() + "\n";
        header = header + Attributes.getOutputHeader() + "\n";
        header = header + "@data\n";
        FileManagement fm = new FileManagement();
        Attribute[] att = Attributes.getInputAttributes();
        try {
            fm.initWrite(trainOUT);
            fm.writeLine(header);
            for (int k = 0; k < validInstances.size(); ++k) {
                int i3 = (Integer)validInstances.get(k);
                boolean[] missing = instances[i3].getInputMissingValues();
                String newInstance = "";
                for (int j = 0; j < numAtt; ++j) {
                    if (missing[j]) {
                        newInstance = newInstance + "?";
                    } else {
                        if (att[j].getType() == 2) {
                            newInstance = newInstance + instances[i3].getInputRealValues(j);
                        }
                        if (att[j].getType() == 1) {
                            newInstance = newInstance + (int)instances[i3].getInputRealValues(j);
                        }
                        if (att[j].getType() == 0) {
                            newInstance = newInstance + instances[i3].getInputNominalValues(j);
                        }
                    }
                    newInstance = newInstance + ", ";
                }
                String className = instances[i3].getOutputNominalValues(0);
                newInstance = newInstance + className + "\n";
                fm.writeLine(newInstance);
            }
            fm.closeWrite();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

