/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Function;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Itemset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5Matrix;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Measures;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyDataset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Results;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.SplitInfo;

public final class M5TreeNode {
    boolean type = true;
    int splitAttr;
    double splitValue;
    Function unsmoothed = new Function();
    Function smoothed = new Function();
    boolean valueNode = true;
    M5TreeNode upNode;
    M5TreeNode leftNode;
    M5TreeNode rightNode;
    Results errors;
    int numParameters;
    SplitInfo sf;
    int lm;
    MyDataset itemsets;
    int model;
    double pruningFactor;
    double deviation;
    static final int LINEAR_REGRESSION = 1;
    static final int REGRESSION_TREE = 2;
    static final int MODEL_TREE = 3;
    static final double SPLIT_NUM = 3.5;

    public M5TreeNode(MyDataset inst, M5TreeNode up) {
        this.upNode = up;
        this.leftNode = null;
        this.rightNode = null;
        this.errors = null;
        this.numParameters = 0;
        this.itemsets = inst;
        this.lm = 0;
        if (up != null) {
            this.model = up.model;
            this.pruningFactor = up.pruningFactor;
            this.deviation = up.deviation;
        }
    }

    public M5TreeNode(MyDataset inst, M5TreeNode up, int optmodel, double optpruningFactor, double std) {
        this.upNode = up;
        this.leftNode = null;
        this.rightNode = null;
        this.errors = null;
        this.numParameters = 0;
        this.itemsets = inst;
        this.lm = 0;
        this.model = optmodel;
        this.pruningFactor = optpruningFactor;
        this.deviation = std;
    }

    public final String singleNodeToString() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("Print single node (" + this.itemsets.numItemsets() + "):\n");
        if (this.type) {
            text.append("    Type:\t\t\tNODE\n");
        } else {
            text.append("    Type:\t\t\tLEAF\n");
        }
        text.append("    Unsmoothed function:\t\t");
        this.unsmoothed.toString(this.itemsets, 0);
        System.out.print("    Smoothed function:\t\t");
        this.smoothed.toString(this.itemsets, 0);
        text.append("    Value node:\t\t\t" + this.valueNode + "\n");
        if (this.errors != null) {
            text.append(this.errors.toString());
        }
        if (this.upNode != null) {
            text.append("    upNode:\t\t\tyes\n");
        } else {
            text.append("    upNode:\t\t\tnull\n");
        }
        if (this.leftNode != null) {
            text.append("    leftNode:\t\t\tyes\n");
        } else {
            text.append("    leftNode:\t\t\tnull\n");
        }
        if (this.rightNode != null) {
            text.append("    rightNode:\t\t\tyes\n");
        } else {
            text.append("    rightNode:\t\t\tnull\n");
        }
        text.append("    number of parameters:\t" + this.numParameters + "\n");
        text.append("    LEAF number(lm):\t\t" + this.lm + "\n");
        text.append("    Number of itemsets\t\t" + this.itemsets.numItemsets() + "\n");
        return text.toString();
    }

    public final String treeToString(int treeLevel, double deviation) {
        StringBuffer text = new StringBuffer();
        if (this.type) {
            int i;
            text.append("\n");
            for (i = 1; i <= treeLevel; ++i) {
                text.append("    ");
            }
            if (this.itemsets.getAttribute(this.splitAttr).name().charAt(0) != '[') {
                text.append(this.itemsets.getAttribute(this.splitAttr).name() + " <= " + M5.doubleToStringG(this.splitValue, 1, 3) + " ");
            } else {
                text.append(this.itemsets.getAttribute(this.splitAttr).name() + " false : ");
            }
            text.append(this.leftNode.treeToString(++treeLevel, deviation));
            --treeLevel;
            for (i = 1; i <= treeLevel; ++i) {
                text.append("    ");
            }
            if (this.itemsets.getAttribute(this.splitAttr).name().charAt(0) != '[') {
                text.append(this.itemsets.getAttribute(this.splitAttr).name() + " >  " + M5.doubleToStringG(this.splitValue, 1, 3) + " ");
            } else {
                text.append(this.itemsets.getAttribute(this.splitAttr).name() + " true : ");
            }
            text.append(this.rightNode.treeToString(++treeLevel, deviation));
            --treeLevel;
        } else {
            text.append(" THEN LM" + this.lm + "\n");
        }
        return text.toString();
    }

    public final int numberOfLinearModels() {
        if (!this.type) {
            return 1;
        }
        return this.leftNode.numberOfLinearModels() + this.rightNode.numberOfLinearModels();
    }

    public final String formulaeToString(boolean smooth) throws Exception {
        StringBuffer text = new StringBuffer();
        if (this.type) {
            text.append(this.leftNode.formulaeToString(smooth));
            text.append(this.rightNode.formulaeToString(smooth));
        } else {
            text.append("    LM" + this.lm + ":  ");
            int startingPoint = 6 + (int)(Math.log((double)this.lm + 0.5) / Math.log(10.0)) + 1 + 3;
            if (smooth) {
                text.append(this.smoothed.toString(this.itemsets, startingPoint));
            } else {
                text.append(this.unsmoothed.toString(this.itemsets, startingPoint));
            }
            text.append("\n");
        }
        return text.toString();
    }

    public final int numLeaves(int leafCounter) {
        if (this.type) {
            this.lm = 0;
            leafCounter = this.leftNode.numLeaves(leafCounter);
            leafCounter = this.rightNode.numLeaves(leafCounter);
        } else {
            this.lm = ++leafCounter;
        }
        return leafCounter;
    }

    public final void split(MyDataset inst) throws Exception {
        this.itemsets = inst;
        if ((double)this.itemsets.numItemsets() < 3.5 || M5.stdDev(this.itemsets.getClassIndex(), this.itemsets) < this.deviation * 0.05) {
            this.type = false;
        } else {
            SplitInfo sMax = new SplitInfo(0, this.itemsets.numItemsets() - 1, -1);
            SplitInfo s = new SplitInfo(0, this.itemsets.numItemsets() - 1, -1);
            for (int j = 0; j < this.itemsets.numAttributes(); ++j) {
                if (j == this.itemsets.getClassIndex()) continue;
                this.itemsets.sort(this.itemsets.getAttribute(j));
                s.attrSplit(j, this.itemsets);
                if (!(Math.abs(s.maxImpurity - sMax.maxImpurity) > 1.0E-6) || !(s.maxImpurity > sMax.maxImpurity + 1.0E-6)) continue;
                sMax = s.copy();
            }
            if (sMax.splitAttr < 0 || sMax.position < 1 || sMax.position > this.itemsets.numItemsets() - 1) {
                this.type = false;
            }
            if (this.type) {
                this.sf = sMax;
                this.splitAttr = sMax.splitAttr;
                this.splitValue = sMax.splitValue;
                this.unsmoothed = new Function(this.splitAttr);
                MyDataset leftInst = new MyDataset(this.itemsets, this.itemsets.numItemsets());
                MyDataset rightInst = new MyDataset(this.itemsets, this.itemsets.numItemsets());
                int nmissings = 0;
                int[] missings = new int[this.itemsets.numItemsets()];
                for (int i = 0; i < this.itemsets.numItemsets(); ++i) {
                    if (!this.itemsets.isMissing(i, this.splitAttr)) {
                        if (this.itemsets.itemset(i).getValue(this.splitAttr) <= this.splitValue) {
                            leftInst.addItemset(this.itemsets.itemset(i));
                            continue;
                        }
                        rightInst.addItemset(this.itemsets.itemset(i));
                        continue;
                    }
                    missings[nmissings] = i;
                    ++nmissings;
                }
                if (nmissings > 0) {
                    double avgRight = 0.0;
                    double avgLeft = 0.0;
                    if (this.itemsets.getAttribute(this.splitAttr).isEnumerate()) {
                        avgRight = rightInst.averageClassValue();
                        avgLeft = leftInst.averageClassValue();
                    } else {
                        double sum;
                        int n;
                        if (rightInst.numItemsets() > 3) {
                            rightInst.sort(this.splitAttr);
                            n = rightInst.numItemsets();
                            sum = rightInst.itemset(n - 1).getClassValue() + rightInst.itemset(n - 2).getClassValue() + rightInst.itemset(n - 3).getClassValue();
                            avgRight = sum / (double)n;
                        } else {
                            avgRight = rightInst.averageClassValue();
                        }
                        if (leftInst.numItemsets() > 3) {
                            leftInst.sort(this.splitAttr);
                            n = leftInst.numItemsets();
                            sum = leftInst.itemset(0).getClassValue() + leftInst.itemset(1).getClassValue() + leftInst.itemset(2).getClassValue();
                            avgLeft = sum / (double)n;
                        } else {
                            avgLeft = leftInst.averageClassValue();
                        }
                    }
                    double avgClassValue = (avgRight + avgLeft) / 2.0;
                    for (int i = 0; i < nmissings; ++i) {
                        if (this.itemsets.itemset(missings[i]).getClassValue() <= avgClassValue) {
                            if (avgRight <= avgLeft) {
                                rightInst.addItemset(this.itemsets.itemset(missings[i]));
                                continue;
                            }
                            leftInst.addItemset(this.itemsets.itemset(missings[i]));
                            continue;
                        }
                        if (avgRight > avgLeft) {
                            rightInst.addItemset(this.itemsets.itemset(missings[i]));
                            continue;
                        }
                        leftInst.addItemset(this.itemsets.itemset(missings[i]));
                    }
                }
                leftInst.compactify();
                rightInst.compactify();
                this.leftNode = new M5TreeNode(leftInst, this);
                this.leftNode.split(leftInst);
                this.rightNode = new M5TreeNode(rightInst, this);
                this.rightNode.split(rightInst);
                if (nmissings > 0) {
                    double avgAtt = this.itemsets.averageValue(this.splitAttr);
                    for (int i = 0; i < nmissings; ++i) {
                        this.itemsets.itemset(missings[i]).setValue(this.splitAttr, avgAtt);
                    }
                }
                this.valueNode();
                if (this.model != 2) {
                    this.unsmoothed = Function.combine(this.unsmoothed, this.leftNode.unsmoothed);
                    this.unsmoothed = Function.combine(this.unsmoothed, this.rightNode.unsmoothed);
                } else {
                    this.unsmoothed = new Function();
                }
            }
        }
        if (!this.type) {
            this.leafNode();
            this.errors = this.unsmoothed.errors(this.itemsets);
        }
    }

    public final void leafNode() throws Exception {
        this.type = false;
        this.unsmoothed.terms[0] = 0;
        this.valueNode();
    }

    public final void valueNode() throws Exception {
        this.valueNode = true;
        this.unsmoothed.coeffs[0] = 0.0;
        for (int i = 0; i <= this.itemsets.numItemsets() - 1; ++i) {
            this.unsmoothed.coeffs[0] = this.unsmoothed.coeffs[0] + this.itemsets.itemset(i).getClassValue();
        }
        this.unsmoothed.coeffs[0] = this.unsmoothed.coeffs[0] / (double)this.itemsets.numItemsets();
    }

    public final void prune() throws Exception {
        if (!this.type) {
            this.errors = this.unsmoothed.errors(this.itemsets);
            this.numParameters = 1;
        } else if (this.model == 1) {
            Function function = new Function(this.itemsets);
            if ((double)function.terms[0] < Math.sqrt(this.itemsets.numItemsets()) * 2.0 && function.terms[0] < 50) {
                this.unsmoothed = function;
            }
            this.regression(this.unsmoothed);
            this.valueNode = false;
            this.errors = this.unsmoothed.errors(this.itemsets);
            this.type = false;
        } else {
            this.leftNode.prune();
            this.rightNode.prune();
            if (this.model != 2) {
                this.unsmoothed = Function.combine(this.unsmoothed, this.leftNode.unsmoothed);
                this.unsmoothed = Function.combine(this.unsmoothed, this.rightNode.unsmoothed);
            } else {
                this.unsmoothed = new Function();
            }
            this.numParameters = this.leftNode.numParameters + this.rightNode.numParameters + 1;
            this.function();
            Results e1 = this.unsmoothed.errors(this.itemsets);
            double eps1 = e1.rootMeanSqrErr * this.factor(this.itemsets.numItemsets(), this.unsmoothed.terms[0] + 1, this.pruningFactor);
            Results e2 = this.errors(this.itemsets, false);
            double eps2 = e2.rootMeanSqrErr * this.factor(this.itemsets.numItemsets(), this.numParameters, this.pruningFactor);
            this.errors = e2;
            if (eps1 <= eps2 || eps1 < this.deviation * 1.0E-5) {
                this.type = false;
                this.numParameters = this.unsmoothed.terms[0] + 1;
                this.errors = e1;
            }
        }
    }

    public final void regression(Function function) {
        int n = this.itemsets.numItemsets();
        int k = function.terms[0] + 1;
        M5Matrix x = new M5Matrix(n, k);
        M5Matrix y = new M5Matrix(n, 1);
        for (int i = 0; i <= n - 1; ++i) {
            x.elements[i][0] = 1.0;
            for (int j = 1; j <= k - 1; ++j) {
                x.elements[i][j] = this.itemsets.itemset(i).getValue(function.terms[j]);
            }
            y.elements[i][0] = this.itemsets.itemset(i).getValue(this.itemsets.getClassIndex());
        }
        function.coeffs = x.regression(y, n, k);
    }

    public final void function() throws Exception {
        boolean flag = false;
        Function f1 = this.unsmoothed;
        if (f1.terms[0] != 0) {
            double sdy = M5.stdDev(this.itemsets.getClassIndex(), this.itemsets);
            this.regression(f1);
            this.valueNode = false;
            if (this.model != 1) {
                Results e1 = f1.errors(this.itemsets);
                double err1 = e1.rootMeanSqrErr * this.factor(this.itemsets.numItemsets(), f1.terms[0] + 1, this.pruningFactor);
                flag = false;
                while (!flag) {
                    int jmin = f1.insignificant(sdy, this.itemsets);
                    if (jmin == -1) {
                        flag = true;
                        continue;
                    }
                    Function f2 = f1.remove(jmin);
                    this.regression(f2);
                    Results e2 = f2.errors(this.itemsets);
                    double err2 = e2.rootMeanSqrErr * this.factor(this.itemsets.numItemsets(), f2.terms[0] + 1, this.pruningFactor);
                    if (err2 > err1 && err2 > this.deviation * 1.0E-5) {
                        flag = true;
                        continue;
                    }
                    f1 = f2;
                    err1 = err2;
                    if (f1.terms[0] != 0) continue;
                    flag = true;
                }
            }
            this.unsmoothed = f1;
        }
        if (this.unsmoothed.terms[0] == 0) {
            this.valueNode();
        }
    }

    public final double factor(int n, int v, double pruningFactor) {
        double factor = 0.0;
        if (n <= v) {
            return 10.0;
        }
        factor = ((double)n + pruningFactor * (double)v) / (double)(n - v);
        return factor;
    }

    public final void smoothen() {
        if (!this.type) {
            this.smoothed = this.unsmoothed.copy();
            if (this.upNode != null) {
                this.smoothenFormula(this);
            }
        } else {
            this.leftNode.smoothen();
            this.rightNode.smoothen();
        }
    }

    public final void smoothenFormula(M5TreeNode current) {
        int i = this.smoothed.terms[0];
        int j = current.upNode.unsmoothed.terms[0];
        int smoothingConstant = 15;
        Function function = Function.combine(this.smoothed, current.upNode.unsmoothed);
        function.coeffs[0] = M5.smoothenValue(this.smoothed.coeffs[0], current.upNode.unsmoothed.coeffs[0], current.itemsets.numItemsets(), smoothingConstant);
        for (int k = function.terms[0]; k >= 1; --k) {
            if (i >= 1 && j >= 1) {
                if (function.terms[k] == this.smoothed.terms[i] && function.terms[k] == current.upNode.unsmoothed.terms[j]) {
                    function.coeffs[k] = M5.smoothenValue(this.smoothed.coeffs[i], current.upNode.unsmoothed.coeffs[j], current.itemsets.numItemsets(), smoothingConstant);
                    --i;
                    --j;
                    continue;
                }
                if (function.terms[k] == this.smoothed.terms[i] && function.terms[k] != current.upNode.unsmoothed.terms[j]) {
                    function.coeffs[k] = M5.smoothenValue(this.smoothed.coeffs[i], 0.0, current.itemsets.numItemsets(), smoothingConstant);
                    --i;
                    continue;
                }
                if (function.terms[k] != this.smoothed.terms[i] && function.terms[k] == current.upNode.unsmoothed.terms[j]) {
                    function.coeffs[k] = M5.smoothenValue(0.0, current.upNode.unsmoothed.coeffs[j], current.itemsets.numItemsets(), smoothingConstant);
                    --j;
                    continue;
                }
                M5.errorMsg("wrong terms value in smoothing_formula().");
                continue;
            }
            if (i < 1 && j < 1) break;
            if (j >= 1) {
                for (int l = k; l >= 1; --l) {
                    function.coeffs[l] = M5.smoothenValue(0.0, current.upNode.unsmoothed.coeffs[j--], current.itemsets.numItemsets(), smoothingConstant);
                }
            } else {
                for (int l = k; l >= 1; --l) {
                    function.coeffs[l] = M5.smoothenValue(this.smoothed.coeffs[i--], 0.0, current.itemsets.numItemsets(), smoothingConstant);
                }
            }
            break;
        }
        this.smoothed = function;
        if (current.upNode.upNode != null) {
            this.smoothenFormula(current.upNode);
        }
    }

    public final String predictionsToString(MyDataset inst, int lmNo, boolean smooth) throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("    Predicting test itemsets (" + inst.getAttribute(inst.getClassIndex()).name() + ", column " + (inst.getClassIndex() + 1) + ")\n\n");
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            int lmNum = this.leafNum(inst.itemset(i));
            if (lmNo != 0 && lmNo != lmNum) continue;
            text.append("      Predicting " + i + " (LM" + lmNum + "):  ");
            text.append(inst.itemset(i).toString() + "\n");
            double value = this.predict(inst.itemset(i), smooth);
            if (!inst.itemset(i).classIsMissing()) {
                text.append("      Actual value: " + M5.doubleToStringG(inst.itemset(i).getClassValue(), 9, 4) + "    Prediction: " + M5.doubleToStringG(value, 9, 4) + "    Abs. error: " + M5.doubleToStringG(Math.abs(inst.itemset(i).getClassValue() - value), 9, 4) + "\n\n");
                continue;
            }
            text.append("      Actual value:   missing    Prediction: " + M5.doubleToStringG(value, 9, 4) + "    Abs. Error: undefined\n\n");
        }
        return text.toString();
    }

    public final int leafNum(Itemset itemset) {
        int lmNum = 0;
        lmNum = !this.type ? this.lm : (itemset.getValue(this.splitAttr) <= this.splitValue ? this.leftNode.leafNum(itemset) : this.rightNode.leafNum(itemset));
        return lmNum;
    }

    public final double predict(Itemset itemset, boolean smooth) {
        double y = 0.0;
        y = !this.type ? (smooth ? this.smoothed.predict(itemset) : (this.valueNode ? this.unsmoothed.coeffs[0] : this.unsmoothed.predict(itemset))) : (itemset.getValue(this.splitAttr) <= this.splitValue ? this.leftNode.predict(itemset, smooth) : this.rightNode.predict(itemset, smooth));
        return y;
    }

    public final Results errors(MyDataset inst, boolean smooth) throws Exception {
        Results e = new Results(0, inst.numItemsets() - 1);
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            double tmp = this.predict(inst.itemset(i), smooth) - inst.itemset(i).getClassValue();
            e.sumErr += tmp;
            e.sumAbsErr += Math.abs(tmp);
            e.sumSqrErr += tmp * tmp;
        }
        e.meanAbsErr = e.sumAbsErr / (double)e.numItemsets;
        e.meanSqrErr = (e.sumSqrErr - e.sumErr * e.sumErr / (double)e.numItemsets) / (double)e.numItemsets;
        e.meanSqrErr = Math.abs(e.meanSqrErr);
        e.rootMeanSqrErr = Math.sqrt(e.meanSqrErr);
        return e;
    }

    public final Measures measures(MyDataset inst, boolean smooth) throws Exception {
        Measures measures = new Measures();
        this.errors = this.errors(inst, smooth);
        int numItemsets = this.errors.numItemsets - this.errors.missingItemsets;
        double[] y1 = new double[numItemsets];
        double[] y2 = new double[numItemsets];
        int count = 0;
        for (int i = 0; i <= inst.numItemsets() - 1; ++i) {
            y1[count] = this.predict(inst.itemset(i), smooth);
            y2[count] = inst.itemset(i).getClassValue();
            ++count;
        }
        measures.correlation = M5.correlation(y1, y2, numItemsets);
        double sd = M5.stdDev(inst.getClassIndex(), inst);
        if (sd > 0.0) {
            measures.meanAbsErr = this.errors.meanAbsErr;
            measures.meanSqrErr = this.errors.meanSqrErr;
            measures.type = 0;
        } else if (numItemsets >= 1) {
            measures.type = 1;
            measures.meanAbsErr = this.errors.meanAbsErr;
            measures.meanSqrErr = this.errors.meanSqrErr;
        } else {
            measures.type = 2;
            measures.meanAbsErr = 0.0;
            measures.meanSqrErr = 0.0;
        }
        return measures;
    }

    public final Measures[] validation(MyDataset inst) throws Exception {
        Measures[] measures = new Measures[]{this.measures(inst, false), this.model == 3 ? this.measures(inst, true) : new Measures()};
        return measures;
    }

    public final M5TreeNode copy(M5TreeNode up) throws Exception {
        M5TreeNode node = new M5TreeNode(this.itemsets, this.upNode);
        node.type = this.type;
        node.splitAttr = this.splitAttr;
        node.splitValue = this.splitValue;
        node.unsmoothed = this.unsmoothed.copy();
        node.smoothed = this.smoothed.copy();
        node.valueNode = this.valueNode;
        node.upNode = up;
        node.errors = this.errors == null ? null : this.errors.copy();
        node.numParameters = node.numParameters;
        node.sf = this.sf == null ? null : this.sf.copy();
        node.itemsets = new MyDataset(this.itemsets, 0, this.itemsets.numItemsets());
        node.lm = this.lm;
        node.model = this.model;
        node.pruningFactor = this.pruningFactor;
        node.deviation = this.deviation;
        node.leftNode = this.leftNode != null ? this.leftNode.copy(node) : null;
        node.rightNode = this.rightNode != null ? this.rightNode.copy(node) : null;
        return node;
    }

    public final String measuresToString(Measures[] measures, MyDataset inst, int lmNo, int verbosity, String str) throws Exception {
        StringBuffer text = new StringBuffer();
        double absDev = M5.absDev(inst.getClassIndex(), inst);
        double sd = M5.stdDev(inst.getClassIndex(), inst);
        text.append("  Without smoothing:\n\n");
        if ((verbosity >= 2 || lmNo != 0) && (str.equals("T") || str.equals("F"))) {
            text.append(this.predictionsToString(inst, lmNo, false));
        }
        text.append(measures[0].toString(absDev, sd, str, "u") + "\n\n");
        text.append("  With smoothing:\n\n");
        if ((verbosity >= 2 || lmNo != 0) && (str.equals("T") || str.equals("F"))) {
            text.append(this.predictionsToString(inst, lmNo, true));
        }
        text.append(measures[1].toString(absDev, sd, str, "s") + "\n\n");
        return text.toString();
    }

    public boolean isLeaf() {
        return !this.type;
    }

    public Function getUnsmoothedFunction() {
        return this.unsmoothed;
    }

    public Function getSmoothedFunction() {
        return this.smoothed;
    }

    public int getSplitingAttribute() {
        return this.splitAttr;
    }

    public double getSplitingValue() {
        return this.splitValue;
    }

    public M5TreeNode getLeftChild() {
        return this.leftNode;
    }

    public M5TreeNode getRightChild() {
        return this.rightNode;
    }
}

