/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractEvaluator;
import net.sourceforge.jclec.fitness.IValueFitness;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.fitness.ValueFitnessComparator;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;

public class StefanoEvaluator
extends AbstractEvaluator
implements IConfigure {
    private static final long serialVersionUID = 3613350191235561000L;
    protected SyntaxTreeClassificationRule rule;
    protected IDataset dataset;
    private boolean maximize = true;
    protected IRandGen randgen;
    protected int maxDerivSize;
    protected double alpha;
    protected int classifiedClass;
    protected transient ValueFitnessComparator comparator;

    public IDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(IDataset dataset) {
        this.dataset = dataset;
    }

    public void setRandGen(IRandGen randgen) {
        this.randgen = randgen;
    }

    public IRandGen getRandGen() {
        return this.randgen;
    }

    public int getMaxDerivSize() {
        return this.maxDerivSize;
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.maxDerivSize = maxDerivSize;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public int getClassifiedClass() {
        return this.classifiedClass;
    }

    public void setClassifiedClass(int classifiedClass) {
        this.classifiedClass = classifiedClass;
    }

    @Override
    public void configure(Configuration settings) {
        double alpha = settings.getDouble("alpha");
        this.setAlpha(alpha);
    }

    @Override
    public void evaluate(List<IIndividual> inds) {
        IDataset.IInstance[] instances = this.getDataset().getInstances();
        int numInstances = instances.length;
        ArrayList<Individual> covers = new ArrayList<Individual>();
        ArrayList<Individual> winners = new ArrayList<Individual>();
        for (IIndividual ind : inds) {
            ind.setFitness(new SimpleValueFitness(0.0));
        }
        int i = 0;
        while (i < numInstances) {
            covers.clear();
            winners.clear();
            for (IIndividual iIndividual : inds) {
                IDataset.IInstance instance = instances[i];
                this.rule = (SyntaxTreeClassificationRule)((Individual)iIndividual).getPhenotype();
                if (!this.rule.covers(instance)) continue;
                covers.add((Individual)iIndividual);
            }
            if (covers.size() > 0) {
                Individual best = (Individual)covers.get(0);
                for (Individual individual : covers) {
                    if (((SyntaxTree)individual.getGenotype()).size() < ((SyntaxTree)best.getGenotype()).size()) {
                        best = individual;
                        winners.clear();
                        continue;
                    }
                    if (((SyntaxTree)individual.getGenotype()).size() != ((SyntaxTree)best.getGenotype()).size()) continue;
                    winners.add(individual);
                }
                if (winners.size() > 0) {
                    best = (Individual)winners.get(this.getRandGen().choose(0, winners.size()));
                }
                best.setFitness(new SimpleValueFitness(((IValueFitness)best.getFitness()).getValue() + 1.0));
            }
            ++i;
        }
    }

    @Override
    public Comparator<IFitness> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ValueFitnessComparator(!this.maximize);
        }
        return this.comparator;
    }

    @Override
    protected void evaluate(IIndividual ind) {
    }
}

