/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.bounce.FormLayout;

public class DefaultAuthenticator
extends Authenticator {
    protected String TITLE = "Enter Username and Password";
    protected String DESCRIPTION = "Please provide your username and password.";
    protected String USERNAME = "Username:";
    protected String PASSWORD = "Password:";
    protected String HOST = "Site:";
    protected String REALM = "Realm:";
    protected String OK_BUTTON = "OK";
    protected String CANCEL_BUTTON = "Cancel";
    private JDialog dialog = null;
    private boolean okPressed = false;
    private JFrame parent = null;
    private JPasswordField passwordField = null;
    private JTextField usernameField = null;
    private JLabel hostField = null;
    private JLabel realmField = null;

    public DefaultAuthenticator(JFrame jFrame) {
        this.parent = jFrame;
    }

    private JDialog getDialog() {
        if (this.dialog == null) {
            Dimension dimension = new Dimension(350, 210);
            this.dialog = new JDialog(this.parent);
            this.dialog.setTitle(this.TITLE);
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            JPanel jPanel = new JPanel(new FormLayout(5, 5));
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            JLabel jLabel = new JLabel(this.DESCRIPTION);
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jPanel.add((Component)jLabel, FormLayout.FULL_FILL);
            jPanel.add(Box.createVerticalStrut(10), FormLayout.FULL_FILL);
            jPanel.add((Component)new JLabel(this.HOST), FormLayout.LEFT);
            this.hostField = new JLabel();
            this.hostField.setFont(this.hostField.getFont().deriveFont(0));
            jPanel.add((Component)this.hostField, FormLayout.RIGHT_FILL);
            jPanel.add((Component)new JLabel(this.REALM), FormLayout.LEFT);
            this.realmField = new JLabel();
            this.realmField.setFont(this.realmField.getFont().deriveFont(0));
            jPanel.add((Component)this.realmField, FormLayout.RIGHT_FILL);
            jPanel.add((Component)new JLabel(this.USERNAME), FormLayout.LEFT);
            this.usernameField = new JTextField();
            jPanel.add((Component)this.usernameField, FormLayout.RIGHT_FILL);
            jPanel.add((Component)new JLabel(this.PASSWORD), FormLayout.LEFT);
            this.passwordField = new JPasswordField();
            jPanel.add((Component)this.passwordField, FormLayout.RIGHT_FILL);
            JButton jButton = new JButton(this.CANCEL_BUTTON);
            jButton.setMnemonic('C');
            jButton.setFont(jButton.getFont().deriveFont(0));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultAuthenticator.this.okPressed = false;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            JButton jButton2 = new JButton(this.OK_BUTTON);
            jButton2.setMnemonic('O');
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultAuthenticator.this.okPressed = true;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            this.dialog.getRootPane().setDefaultButton(jButton2);
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
            jPanel2.setBorder(new EmptyBorder(10, 0, 3, 0));
            jPanel2.add(jButton2);
            jPanel2.add(jButton);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    DefaultAuthenticator.this.okPressed = false;
                    DefaultAuthenticator.this.dialog.setVisible(false);
                }
            });
            this.dialog.setContentPane(jPanel3);
            this.dialog.setDefaultCloseOperation(1);
            this.dialog.setSize(dimension);
        }
        return this.dialog;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        JDialog jDialog = this.getDialog();
        this.passwordField.setText("");
        this.usernameField.setText("");
        this.hostField.setText(this.getRequestingHost());
        this.realmField.setText(this.getRequestingPrompt());
        jDialog.setLocationRelativeTo(this.parent);
        jDialog.setVisible(true);
        if (this.okPressed) {
            return new PasswordAuthentication(this.usernameField.getText(), this.passwordField.getPassword());
        }
        return null;
    }
}

