## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  dpi = 120,
  fig.align = "center"
)
set.seed(1)
require(lidR)

## -----------------------------------------------------------------------------
library(crookR)
data("example_stem")

## -----------------------------------------------------------------------------

library(crookR)
data("example_stem")
str(example_stem)
head(example_stem)


## -----------------------------------------------------------------------------
stem_1dir <- crook_deform(
  x = example_stem,
  krok_length     = 0.5,
  krok_start      = 4.0,
  krok_type       = "1dir", 
  krok_deviation  = 0.08,   # try 0.05..0.12 for milder/stronger bends
  az              = 0,      # bend along +X
  spar            = 0.8
)

# Quick plan-view check

op <- par(mfrow = c(1,2), mar = c(3,3,2,1))
plot(example_stem$X, example_stem$Z, pch=16, cex=0.3, xlab="X (m)", ylab="Z (m)", main="Original")
plot(stem_1dir$X,     stem_1dir$Z,     pch=16, cex=0.3, xlab="X (m)", ylab="Z (m)", main="Crooked 1dir (az = 0°)")
par(op)

## -----------------------------------------------------------------------------
stem_2dir <- crook_deform( 
  x = example_stem,
  krok_length = 0.5,
  krok_start = 4.0,
  krok_type = "2dir",
  krok_deviation = 0.1,
  inflektion_X = 1/3,    # inflection at ~33% of the deformed length
  inflektion_ext = 1/2,    # second leg amplitude relative to first
  az = 0,     
  spar = 0.8
  )

op <- par(mfrow = c(1,2), mar = c(3,3,2,1))
plot(example_stem$X, example_stem$Z, pch=16, cex=0.3, xlab="X (m)", ylab="Z (m)", main="Original")
plot(stem_2dir$X,     stem_2dir$Z,     pch=16, cex=0.3, xlab="X (m)", ylab="Z (m)", main="Crooked 2dir (ip = 0.33)")
par(op)

