## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
# Ensure the temporary library from R CMD check is visible (esp. on Windows)
libdir <- Sys.getenv("R_LIBS")
if (nzchar(libdir)) {
  parts <- strsplit(libdir, .Platform$path.sep, fixed = TRUE)[[1]]
  .libPaths(unique(c(parts, .libPaths())))
}

# now load your package
suppressPackageStartupMessages(library(ecotourism))


## ----eval=TRUE, echo=TRUE, message=FALSE, warning=FALSE-----------------------
library(dplyr)
library(ecotourism)

data("weather_stations")
weather_stations |> glimpse()


## ----echo=TRUE, eval=FALSE, fig.width=6, fig.height=4-------------------------
# library(ggplot2)
# library(ggthemes)
# 
# ggplot() +
#   geom_sf(data = oz_lga) +
#   geom_point(data = weather_stations,
#              aes(x = stn_lon, y = stn_lat, colour = stn_state),
#              alpha = 0.6, size = 1) +
#   theme_map() +
#   theme(legend.position = "none")

