/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.fst.SimpleTagger;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PipeUtils;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPipeUtils
extends TestCase {
    private static String data = "f1 f2 CL1\nf1 f3 CL2";

    public TestPipeUtils(String name) {
        super(name);
    }

    public void testConcatenatePipes() {
        StupidPipe p1 = new StupidPipe();
        SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence p2 = new SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence();
        p2.instanceFrom(new Instance(data, null, null, null));
        TestPipeUtils.assertEquals(3, p2.getDataAlphabet().size());
        Pipe serial = PipeUtils.concatenatePipes(p1, p2);
        Alphabet dict = serial.getDataAlphabet();
        TestPipeUtils.assertEquals(3, dict.size());
        TestPipeUtils.assertTrue(dict == p2.getDataAlphabet());
    }

    public void testConcatenateNullPipes() {
        StupidPipe p1 = new StupidPipe();
        SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence p2 = new SimpleTagger.SimpleTaggerSentence2FeatureVectorSequence();
        Pipe serial = PipeUtils.concatenatePipes(p1, p2);
        p2.instanceFrom(new Instance(data, null, null, null));
        TestPipeUtils.assertEquals(3, serial.getDataAlphabet().size());
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestPipeUtils.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestPipeUtils(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestPipeUtils.suite();
        }
        TestRunner.run(theSuite);
    }

    private static class StupidPipe
    extends Pipe {
        private StupidPipe() {
        }

        @Override
        public Instance pipe(Instance carrier) {
            System.out.println("StupidPipe says hi.");
            return carrier;
        }
    }
}

