/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.classify.MaxEnt;
import cc.mallet.topics.DMRTopicModel;
import cc.mallet.topics.TopicAssignment;
import cc.mallet.topics.WorkerCallable;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelSequence;
import cc.mallet.util.Randoms;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class DMRCallable
extends WorkerCallable
implements Callable<Integer> {
    MaxEnt dmrParameters;
    int numFeatures;
    int defaultFeatureIndex;
    DMRTopicModel model;

    public DMRCallable(int numTopics, DMRTopicModel model, double beta, Randoms random, ArrayList<TopicAssignment> data, int[][] typeTopicCounts, int[] tokensPerTopic, int startDoc, int numDocs) {
        this.data = data;
        this.model = model;
        this.dmrParameters = model.dmrParameters;
        this.numFeatures = model.numFeatures;
        this.defaultFeatureIndex = model.defaultFeatureIndex;
        this.numTopics = numTopics;
        this.numTypes = typeTopicCounts.length;
        if (Integer.bitCount(numTopics) == 1) {
            this.topicMask = numTopics - 1;
            this.topicBits = Integer.bitCount(this.topicMask);
        } else {
            this.topicMask = Integer.highestOneBit(numTopics) * 2 - 1;
            this.topicBits = Integer.bitCount(this.topicMask);
        }
        this.typeTopicCounts = typeTopicCounts;
        this.tokensPerTopic = tokensPerTopic;
        this.alpha = new double[numTopics];
        this.beta = beta;
        this.betaSum = beta * (double)this.numTypes;
        this.random = random;
        this.startDoc = startDoc;
        this.numDocs = numDocs;
        this.cachedCoefficients = new double[numTopics];
    }

    @Override
    public Integer call() {
        this.smoothingOnlyMass = 0.0;
        int changed = 0;
        for (int doc = this.startDoc; doc < this.data.size() && doc < this.startDoc + this.numDocs; ++doc) {
            Instance instance = ((TopicAssignment)this.data.get((int)doc)).instance;
            this.alpha = this.model.alphaCache[doc];
            this.alphaSum = this.model.alphaSumCache[doc];
            this.smoothingOnlyMass = 0.0;
            for (int topic = 0; topic < this.numTopics; ++topic) {
                this.smoothingOnlyMass += this.alpha[topic] * this.beta / ((double)this.tokensPerTopic[topic] + this.betaSum);
                this.cachedCoefficients[topic] = this.alpha[topic] / ((double)this.tokensPerTopic[topic] + this.betaSum);
            }
            FeatureSequence tokenSequence = (FeatureSequence)instance.getData();
            LabelSequence topicSequence = ((TopicAssignment)this.data.get((int)doc)).topicSequence;
            changed += this.sampleTopicsForOneDoc(tokenSequence, topicSequence, true);
        }
        if (this.shouldBuildLocalCounts) {
            this.buildLocalTypeTopicCounts();
        }
        this.shouldSaveState = false;
        return changed;
    }
}

