/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.MixedConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class ClausesManager
extends MixedConstraintManager {
    public SConstraint makeConstraint(Solver solver, Variable[] vars, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            IntDomainVar[] vs = new IntDomainVar[vars.length];
            solver._to(vars, vs);
            ClauseStore cs = new ClauseStore(vs, solver.getEnvironment());
            if (options.contains("cp:entail")) {
                cs.setEfficientEntailmentTest();
            }
            Constraint[] constraints = (Constraint[])((Object[])parameters)[1];
            for (int c = 0; c < constraints.length; ++c) {
                ComponentConstraint clause = (ComponentConstraint)constraints[c];
                int offset = (Integer)clause.getParameters();
                IntegerVariable[] posLits = new IntegerVariable[offset];
                IntegerVariable[] negLits = new IntegerVariable[clause.getNbVars() - offset];
                for (int v = 0; v < clause.getNbVars(); ++v) {
                    if (v < offset) {
                        posLits[v] = (IntegerVariable)clause.getVariables()[v];
                        continue;
                    }
                    negLits[v - offset] = (IntegerVariable)clause.getVariables()[v];
                }
                cs.addClause(solver.getVar(posLits), solver.getVar(negLits));
            }
            return cs;
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }
}

