/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ElementG
extends AbstractBinIntSConstraint {
    int[] lval;
    protected IStateInt lastIndexInf;
    protected IStateInt lastIndexSup;
    protected IStateInt lastVarInf;
    protected IStateInt lastVarSup;
    protected IStateInt[] domainSize;
    private final IEnvironment environment;

    public ElementG(IntDomainVar index, int[] values, IntDomainVar var, IEnvironment environment) {
        super(index, var);
        this.environment = environment;
        this.lval = values;
        this.domainSize = new IStateInt[2];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return "ElementG";
    }

    @Override
    public String pretty() {
        return this.v1.toString() + " = nth(" + this.v0.toString() + ", " + StringUtils.pretty(this.lval) + ')';
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        if (i == 0) {
            int minIndex = this.v0.getInf();
            for (int index = this.lastIndexInf.get(); index < minIndex; ++index) {
                this.updateValueFromIndex(index);
            }
            this.lastIndexInf.set(minIndex);
        } else {
            int minVar = this.v1.getInf();
            for (int index = this.lastVarInf.get(); index < minVar; ++index) {
                this.updateIndexFromValue(index);
            }
            this.lastVarInf.set(minVar);
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        if (i == 0) {
            int maxIndex = this.lastIndexSup.get();
            if (maxIndex >= this.lval.length) {
                maxIndex = this.lval.length - 1;
            }
            for (int index = this.v0.getSup() + 1; index <= maxIndex; ++index) {
                this.updateValueFromIndex(index);
            }
            this.lastIndexSup.set(this.v0.getSup());
        } else {
            int maxVar = this.lastVarSup.get();
            for (int index = this.v1.getSup() + 1; index <= maxVar; ++index) {
                this.updateIndexFromValue(index);
            }
            this.lastVarSup.set(this.v1.getSup());
        }
    }

    @Override
    public void awakeOnBounds(int varIdx) throws ContradictionException {
        this.awakeOnInf(varIdx);
        this.awakeOnSup(varIdx);
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        if (i == 0) {
            if (this.v0.getVal() - 1 < this.lval.length) {
                this.v1.instantiate(this.lval[this.v0.getVal() - 1], this, false);
            }
        } else {
            int index;
            int maxVar = this.lastVarSup.get();
            for (index = this.v1.getVal(); index < maxVar; ++index) {
                this.updateIndexFromValue(index + 1);
            }
            for (index = this.lastVarInf.get(); index < this.v1.getVal(); ++index) {
                this.updateIndexFromValue(index);
            }
            this.lastVarInf.set(this.v1.getVal());
            this.lastVarSup.set(this.v1.getVal());
        }
    }

    @Override
    public void awakeOnRem(int i, int x) throws ContradictionException {
        if (i == 0) {
            this.updateValueFromIndex(x);
        } else {
            this.updateIndexFromValue(x);
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v1.isInstantiated()) {
            boolean b = true;
            DisposableIntIterator iter = this.v0.getDomain().getIterator();
            while (iter.hasNext()) {
                int val = iter.next();
                b &= val >= 0;
                b &= val < this.lval.length;
                b &= this.lval[val] == this.v1.getVal();
            }
            iter.dispose();
            if (b) {
                return Boolean.TRUE;
            }
        } else {
            boolean b;
            int val;
            DisposableIntIterator iter = this.v0.getDomain().getIterator();
            for (b = false; iter.hasNext() && !b; b &= this.v1.canBeInstantiatedTo(this.lval[val])) {
                val = iter.next();
                b = val >= 0;
                b &= val < this.lval.length;
            }
            iter.dispose();
            if (b) {
                return null;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isSatisfied() {
        return this.lval[this.v0.getVal()] == this.v1.getVal();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.awakeOnInf(0);
        this.awakeOnInf(1);
        this.awakeOnSup(0);
        this.awakeOnSup(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awake() throws ContradictionException {
        int i;
        int left;
        int i2;
        int heigth = this.lval[0];
        int offset = this.lval[0];
        for (i2 = 1; i2 < this.lval.length; ++i2) {
            if (heigth < this.lval[i2]) {
                heigth = this.lval[i2];
            }
            if (offset <= this.lval[i2]) continue;
            offset = this.lval[i2];
        }
        heigth = heigth - offset + 1;
        int[] value = new int[this.lval.length];
        int[] occur = new int[this.lval.length];
        int[] firstPos = new int[this.lval.length];
        int[] redirect = new int[heigth];
        for (i2 = 0; i2 < heigth; ++i2) {
            redirect[i2] = -1;
        }
        int nbVal = 0;
        for (int i3 = 0; i3 < this.lval.length; ++i3) {
            if (redirect[this.lval[i3] - offset] == -1) {
                value[nbVal] = this.lval[i3];
                redirect[this.lval[i3] - offset] = nbVal;
                occur[nbVal] = 1;
                firstPos[nbVal] = i3 + 1;
                ++nbVal;
                continue;
            }
            occur[redirect[this.lval[i3] - offset]] = occur[redirect[this.lval[i3] - offset]] + 1;
        }
        DisposableIntIterator iter = this.v0.getDomain().getIterator();
        int right = left = Integer.MIN_VALUE;
        try {
            while (iter.hasNext()) {
                int index = iter.next();
                if (index - 1 >= this.lval.length || index - 1 < 0 || this.v1.canBeInstantiatedTo(this.lval[index - 1])) continue;
                if (index == right + 1) {
                    right = index;
                    continue;
                }
                this.v0.removeInterval(left, right, this, false);
                left = index;
                right = index;
            }
            this.v0.removeInterval(left, right, this, false);
        }
        finally {
            iter.dispose();
        }
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        for (i = 0; i < nbVal; ++i) {
            int val = value[i];
            if (!this.v1.canBeInstantiatedTo(val)) continue;
            while (occur[i] > 1 && !this.v0.canBeInstantiatedTo(firstPos[i])) {
                occur[i] = occur[i] - 1;
                int j = firstPos[i] + 1;
                while (this.lval[j - 1] != val) {
                    ++j;
                }
                firstPos[i] = j;
            }
            if (occur[i] != 1 || this.v0.canBeInstantiatedTo(firstPos[i])) continue;
            if (val == right + 1) {
                right = val;
                continue;
            }
            this.v0.removeInterval(left, right, this, false);
            left = val;
            right = val;
        }
        this.v0.removeInterval(left, right, this, false);
        if (this.v0.getInf() < 1) {
            this.v0.updateInf(1, this, false);
            this.lastIndexInf = this.environment.makeInt(1);
        } else {
            this.lastIndexInf = this.environment.makeInt(this.v0.getInf());
        }
        if (this.lval.length < this.v0.getSup()) {
            this.v0.updateSup(this.lval.length, this, false);
            this.lastIndexSup = this.environment.makeInt(this.lval.length);
        } else {
            this.lastIndexSup = this.environment.makeInt(this.v0.getSup());
        }
        if (offset > this.v1.getInf()) {
            this.v1.updateInf(offset, this, false);
            this.lastVarInf = this.environment.makeInt(offset);
        } else {
            this.lastVarInf = this.environment.makeInt(this.v1.getInf());
        }
        if (this.v1.getSup() > heigth + offset - 1) {
            this.v1.updateSup(heigth + offset - 1, this, false);
            this.lastVarSup = this.environment.makeInt(heigth + offset - 1);
        } else {
            this.lastVarSup = this.environment.makeInt(this.v1.getSup());
        }
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        for (i = offset; i < heigth + offset - 1; ++i) {
            if (!this.v1.canBeInstantiatedTo(i) || redirect[i - offset] != -1) continue;
            if (i == right + 1) {
                right = i;
                continue;
            }
            this.v0.removeInterval(left, right, this, false);
            left = i;
            right = i;
        }
        this.v0.removeInterval(left, right, this, false);
        this.domainSize[0] = this.environment.makeInt(this.v0.getDomainSize());
        this.domainSize[1] = this.environment.makeInt(this.v1.getDomainSize());
    }

    protected void updateValueFromIndex(int i) throws ContradictionException {
        if (this.v0.getDomainSize() != this.domainSize[0].get() && i < this.lval.length) {
            int j;
            int val = 0;
            if (i > 0) {
                val = this.lval[i - 1];
            } else {
                this.fail();
            }
            for (j = this.v0.getInf(); j <= this.v0.getSup() && j <= this.lval.length && (j == i || j - 1 >= 0 && this.lval[j - 1] != val || !this.v0.canBeInstantiatedTo(j)); ++j) {
            }
            if ((j > this.lval.length || j > this.v0.getSup()) && this.v1.canBeInstantiatedTo(val)) {
                this.v1.removeVal(val, this, false);
                this.domainSize[1].set(this.v1.getDomainSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexFromValue(int v) throws ContradictionException {
        if (this.v1.getDomainSize() != this.domainSize[1].get()) {
            int left;
            DisposableIntIterator iter = this.v0.getDomain().getIterator();
            int right = left = Integer.MIN_VALUE;
            try {
                while (iter.hasNext()) {
                    int index = iter.next();
                    if (index - 1 >= this.lval.length || index - 1 < 0 || this.lval[index - 1] != v || !this.v0.canBeInstantiatedTo(index)) continue;
                    if (index == right + 1) {
                        right = index;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this, false);
                    left = index;
                    right = index;
                }
                this.v0.removeInterval(left, right, this, false);
                this.domainSize[0].set(this.v0.getDomainSize());
            }
            finally {
                iter.dispose();
            }
        }
    }
}

