/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ElementV
extends AbstractLargeIntSConstraint {
    protected IStateBool valueUpdateNeeded;
    protected IStateBool indexUpdateNeeded;
    private int offset;

    public ElementV(IntDomainVar[] vars, int offset, IEnvironment environment) {
        super(ConstraintEvent.QUADRATIC, vars);
        this.offset = offset;
        this.initElementV(environment);
    }

    private void initElementV(IEnvironment environment) {
        this.valueUpdateNeeded = environment.makeBool(true);
        this.indexUpdateNeeded = environment.makeBool(true);
    }

    @Override
    public String toString() {
        return "eltV";
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public String pretty() {
        return this.getValueVar().toString() + " = nth(" + this.getIndexVar().toString() + ", " + StringUtils.pretty((IPretty[])this.vars, 0, ((IntDomainVar[])this.vars).length - 2) + ")";
    }

    protected IntDomainVar getIndexVar() {
        return ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 2];
    }

    protected IntDomainVar getValueVar() {
        return ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 1];
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[tuple[((IntDomainVar[])this.vars).length - 2] + this.offset] == tuple[((IntDomainVar[])this.vars).length - 1];
    }

    protected void updateValueFromIndex() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minval = Integer.MAX_VALUE;
        int maxval = Integer.MIN_VALUE;
        DisposableIntIterator iter = idxVar.getDomain().getIterator();
        while (iter.hasNext()) {
            int feasibleIndex = iter.next();
            minval = Math.min(minval, ((IntDomainVar[])this.vars)[feasibleIndex + this.offset].getInf());
            maxval = Math.max(maxval, ((IntDomainVar[])this.vars)[feasibleIndex + this.offset].getSup());
        }
        iter.dispose();
        valVar.updateInf(minval, this, false);
        valVar.updateSup(maxval, this, false);
        if (valVar.hasEnumeratedDomain()) {
            int v = valVar.getInf();
            while (v < valVar.getSup()) {
                boolean possibleV = false;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext() && !possibleV) {
                    int tentativeIdx = it.next();
                    if (!((IntDomainVar[])this.vars)[tentativeIdx + this.offset].canBeInstantiatedTo(v)) continue;
                    possibleV = true;
                    break;
                }
                it.dispose();
                if (!possibleV) {
                    valVar.removeVal(v, this, false);
                }
                v = valVar.getNextDomainValue(v);
            }
        }
        this.valueUpdateNeeded.set(false);
    }

    protected void updateIndexFromValue() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minFeasibleIndex = Math.max(0 - this.offset, idxVar.getInf());
        int maxFeasibleIndex = Math.min(idxVar.getSup(), ((IntDomainVar[])this.vars).length - 3 - this.offset);
        int cause = this.cIndices[((IntDomainVar[])this.vars).length - 2];
        if (valVar.hasEnumeratedDomain()) {
            cause = -1;
        }
        while (idxVar.canBeInstantiatedTo(minFeasibleIndex) && !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[minFeasibleIndex + this.offset])) {
            ++minFeasibleIndex;
        }
        idxVar.updateInf(minFeasibleIndex, this, false);
        while (idxVar.canBeInstantiatedTo(maxFeasibleIndex) && !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[maxFeasibleIndex + this.offset])) {
            --maxFeasibleIndex;
        }
        idxVar.updateSup(maxFeasibleIndex, this, false);
        if (idxVar.hasEnumeratedDomain()) {
            for (int i = minFeasibleIndex + 1; i < maxFeasibleIndex - 1; ++i) {
                if (!idxVar.canBeInstantiatedTo(i) || valVar.canBeEqualTo(((IntDomainVar[])this.vars)[i + this.offset])) continue;
                idxVar.removeVal(i, this, false);
            }
        }
        if (idxVar.isInstantiated()) {
            this.equalityBehaviour();
        }
        this.indexUpdateNeeded.set(false);
    }

    protected void equalityBehaviour() throws ContradictionException {
        int val;
        int right;
        int left;
        assert (this.getIndexVar().isInstantiated());
        int indexVal = this.getIndexVar().getVal();
        IntDomainVar valVar = this.getValueVar();
        IntDomainVar targetVar = ((IntDomainVar[])this.vars)[indexVal + this.offset];
        valVar.updateInf(targetVar.getInf(), this, false);
        valVar.updateSup(targetVar.getSup(), this, false);
        targetVar.updateInf(valVar.getInf(), this, false);
        targetVar.updateSup(valVar.getSup(), this, false);
        if (targetVar.hasEnumeratedDomain()) {
            right = left = Integer.MIN_VALUE;
            val = valVar.getInf();
            while (val < valVar.getSup()) {
                if (!targetVar.canBeInstantiatedTo(val)) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        valVar.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                }
                val = valVar.getNextDomainValue(val);
            }
            valVar.removeInterval(left, right, this, false);
        }
        if (valVar.hasEnumeratedDomain()) {
            right = left = Integer.MIN_VALUE;
            val = targetVar.getInf();
            while (val < targetVar.getSup()) {
                if (!valVar.canBeInstantiatedTo(val)) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        targetVar.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                }
                val = targetVar.getNextDomainValue(val);
            }
            targetVar.removeInterval(left, right, this, false);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        int n = ((IntDomainVar[])this.vars).length;
        IntDomainVar idxVar = this.getIndexVar();
        idxVar.updateInf(0 - this.offset, this, false);
        idxVar.updateSup(n - 3 - this.offset, this, false);
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.indexUpdateNeeded.get()) {
            this.updateIndexFromValue();
        }
        if (this.getIndexVar().isInstantiated()) {
            this.equalityBehaviour();
        } else if (this.valueUpdateNeeded.get()) {
            this.updateValueFromIndex();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                this.updateValueFromIndex();
            }
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].updateInf(valVar.getInf(), this, false);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.updateInf(((IntDomainVar[])this.vars)[idx].getInf(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else if (((IntDomainVar[])this.vars)[idx].getInf() > valVar.getInf()) {
                int minval = Integer.MAX_VALUE;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext()) {
                    int feasibleIndex = it.next() + this.offset;
                    minval = Math.min(minval, ((IntDomainVar[])this.vars)[feasibleIndex].getInf());
                }
                it.dispose();
                valVar.updateInf(minval, this, true);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                this.updateValueFromIndex();
            }
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].updateSup(valVar.getSup(), this, false);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.updateSup(((IntDomainVar[])this.vars)[idx].getSup(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else if (((IntDomainVar[])this.vars)[idx].getSup() < valVar.getSup()) {
                int maxval = Integer.MIN_VALUE;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext()) {
                    int feasibleIndex = it.next() + this.offset;
                    maxval = Math.max(maxval, ((IntDomainVar[])this.vars)[feasibleIndex].getSup());
                }
                it.dispose();
                valVar.updateSup(maxval, this, true);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            this.equalityBehaviour();
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].instantiate(valVar.getVal(), this, false);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.instantiate(((IntDomainVar[])this.vars)[idx].getVal(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else {
                this.updateValueFromIndex();
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            this.updateValueFromIndex();
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].removeVal(x, this, false);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.removeVal(x, this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset) && valVar.hasEnumeratedDomain()) {
            boolean existsSupport = false;
            DisposableIntIterator it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                int feasibleIndex = it.next() + this.offset;
                if (!((IntDomainVar[])this.vars)[feasibleIndex].canBeInstantiatedTo(x)) continue;
                existsSupport = true;
            }
            it.dispose();
            if (!existsSupport) {
                valVar.removeVal(x, this, true);
            }
        }
    }

    @Override
    public Boolean isEntailed() {
        int feasibleIndex;
        DisposableIntIterator it;
        Boolean isEntailed = null;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (valVar.isInstantiated() && idxVar.getInf() + this.offset >= 0 && idxVar.getSup() + this.offset < ((IntDomainVar[])this.vars).length - 2) {
            boolean allEqualToValVar = true;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.offset;
                if (((IntDomainVar[])this.vars)[feasibleIndex].isInstantiatedTo(valVar.getVal())) continue;
                allEqualToValVar = false;
            }
            it.dispose();
            if (allEqualToValVar) {
                isEntailed = Boolean.TRUE;
            }
        }
        if (isEntailed != Boolean.TRUE) {
            boolean existsSupport = false;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.offset;
                if (feasibleIndex < 0 || feasibleIndex >= ((IntDomainVar[])this.vars).length - 2 || !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[feasibleIndex])) continue;
                existsSupport = true;
            }
            it.dispose();
            if (!existsSupport) {
                isEntailed = Boolean.FALSE;
            }
        }
        return isEntailed;
    }
}

