/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class InverseChannelingWithinRange
extends AbstractLargeIntSConstraint {
    protected int nbx;
    protected int nby;
    private int min;

    public InverseChannelingWithinRange(IntDomainVar[] allVars, int n) {
        super(ConstraintEvent.LINEAR, allVars);
        this.nbx = n;
        this.min = Integer.MAX_VALUE;
        for (int i = 0; i < allVars.length; ++i) {
            IntDomainVar var = allVars[i];
            this.min = Math.min(this.min, var.getInf());
        }
        this.nby = allVars.length - n;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public void propagate() throws ContradictionException {
        int i;
        int idx;
        for (idx = 0; idx < this.nbx; ++idx) {
            for (i = 0; i < this.nby; ++i) {
                if (((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min)) continue;
                ((IntDomainVar[])this.vars)[i + this.nbx].removeVal(idx + this.min, this, false);
            }
        }
        for (idx = this.nbx; idx < ((IntDomainVar[])this.vars).length; ++idx) {
            for (i = 0; i < this.nbx; ++i) {
                if (((IntDomainVar[])this.vars)[idx].canBeInstantiatedTo(i + this.min)) continue;
                ((IntDomainVar[])this.vars)[i].removeVal(idx - this.nbx + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        block3: {
            int val;
            block2: {
                val = ((IntDomainVar[])this.vars)[idx].getInf() - this.min;
                if (idx >= this.nbx || val >= this.nby) break block2;
                for (int i = 0; i < val; ++i) {
                    ((IntDomainVar[])this.vars)[i + this.nbx].removeVal(idx + this.min, this, false);
                }
                break block3;
            }
            if (idx < this.nbx || val >= this.nbx) break block3;
            for (int i = 0; i < val; ++i) {
                ((IntDomainVar[])this.vars)[i].removeVal(idx - this.nbx + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        block3: {
            int val;
            block2: {
                val = ((IntDomainVar[])this.vars)[idx].getSup() - this.min + 1;
                if (idx >= this.nbx || val >= this.nby) break block2;
                for (int i = val; i < this.nby; ++i) {
                    ((IntDomainVar[])this.vars)[i + this.nbx].removeVal(idx + this.min, this, false);
                }
                break block3;
            }
            if (idx < this.nbx || val >= this.nbx) break block3;
            for (int i = val; i < this.nbx; ++i) {
                ((IntDomainVar[])this.vars)[i].removeVal(idx - this.nbx + this.min, this, false);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx < this.nbx && x < this.nby) {
            ((IntDomainVar[])this.vars)[x - this.min + this.nbx].removeVal(idx + this.min, this, false);
        } else if (idx >= this.nbx && x < this.nbx) {
            ((IntDomainVar[])this.vars)[x - this.min].removeVal(idx - this.nbx + this.min, this, false);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        block3: {
            int val;
            block2: {
                val = ((IntDomainVar[])this.vars)[idx].getVal() - this.min;
                if (idx >= this.nbx || val >= this.nby) break block2;
                ((IntDomainVar[])this.vars)[val + this.nbx].instantiate(idx + this.min, this, false);
                for (int i = 0; i < this.nbx; ++i) {
                    if (i == idx) continue;
                    ((IntDomainVar[])this.vars)[i].removeVal(val + this.min, this, false);
                }
                break block3;
            }
            if (idx < this.nbx || val >= this.nbx) break block3;
            ((IntDomainVar[])this.vars)[val].instantiate(idx - this.nbx + this.min, this, false);
            for (int i = this.nbx; i < ((IntDomainVar[])this.vars).length; ++i) {
                if (i == idx) continue;
                ((IntDomainVar[])this.vars)[i].removeVal(val + this.min, this, false);
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int x;
        int i;
        for (i = 0; i < this.nbx; ++i) {
            x = tuple[i];
            if (x >= this.nby || tuple[x - this.min + this.nbx] == i + this.min) continue;
            return false;
        }
        for (i = this.nbx; i < tuple.length; ++i) {
            x = tuple[i];
            if (x >= this.nbx || tuple[x - this.min] == i - this.nbx + this.min) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        IntDomainVar var;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("InverseChannelingWithinRange({");
        for (i = 0; i < this.nbx; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.nby; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = ((IntDomainVar[])this.vars)[this.nbx + i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

