/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sat;

import choco.cp.solver.constraints.integer.bool.sat.BinaryWLClause;
import choco.cp.solver.constraints.integer.bool.sat.DynWLClause;
import choco.cp.solver.constraints.integer.bool.sat.Lits;
import choco.cp.solver.constraints.integer.bool.sat.Vec;
import choco.cp.solver.constraints.integer.bool.sat.WLClause;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TLongIntHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

public final class ClauseStore
extends AbstractLargeIntSConstraint {
    public static final boolean nonincprop = false;
    public boolean efficient_entailment_test = false;
    protected final Lits voc;
    protected final ArrayList<WLClause> listclause;
    protected final LinkedList<WLClause> listToPropagate;
    protected final LinkedList<IntDomainVar> instToOne;
    protected final LinkedList<IntDomainVar> instToZero;
    private final TLongIntHashMap indexes;
    protected final int[] fineDegree;
    protected int nbNonBinaryClauses;
    protected int[][][] clause_entailed;
    protected IStateIntVector clauses_not_entailed;
    private final IEnvironment environment;

    public ClauseStore(IntDomainVar[] vars, IEnvironment environment) {
        this(vars, new ArrayList<WLClause>(12), new Lits(), environment);
        this.voc.init(vars);
    }

    public ClauseStore(IntDomainVar[] vars, ArrayList<WLClause> listclause, Lits voc, IEnvironment environment) {
        super(ConstraintEvent.QUADRATIC, vars);
        this.environment = environment;
        this.voc = voc;
        this.listclause = listclause;
        this.listToPropagate = new LinkedList();
        this.instToOne = new LinkedList();
        this.instToZero = new LinkedList();
        this.nbNonBinaryClauses = 0;
        this.fineDegree = new int[vars.length];
        this.indexes = new TLongIntHashMap(vars.length);
        for (int v = 0; v < vars.length; ++v) {
            this.indexes.put(vars[v].getIndex(), v);
        }
    }

    public ArrayList<WLClause> getClauses() {
        return this.listclause;
    }

    public void setEfficientEntailmentTest() {
        this.efficient_entailment_test = true;
    }

    public void clearEfficientEntailmentTest() {
        this.efficient_entailment_test = false;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    public Lits getVoc() {
        return this.voc;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filterOnInst(idx);
    }

    public void filterOnInst(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getVal();
        int sidx = idx + 1;
        if (val == 1) {
            int vocidx = -sidx;
            Vec<WLClause> wlist = this.voc.watches(vocidx);
            if (wlist != null) {
                for (int i = 0; i < wlist.size(); ++i) {
                    WLClause clause = wlist.get(i);
                    if (!clause.propagate(vocidx, i)) continue;
                    --i;
                }
            }
        } else {
            Vec<WLClause> wlist = this.voc.watches(sidx);
            if (wlist != null) {
                for (int i = 0; i < wlist.size(); ++i) {
                    WLClause clause = wlist.get(i);
                    if (!clause.propagate(sidx, i)) continue;
                    --i;
                }
            }
        }
        if (this.efficient_entailment_test) {
            this.maintainEfficientEntailment(idx, val);
        }
    }

    public void maintainEfficientEntailment(int idx, int val) {
        if (val == 1) {
            for (int i = 0; i < this.clause_entailed[idx][1].length; ++i) {
                this.clauses_not_entailed.remove(this.clause_entailed[idx][1][i]);
            }
        } else {
            for (int i = 0; i < this.clause_entailed[idx][0].length; ++i) {
                this.clauses_not_entailed.remove(this.clause_entailed[idx][0][i]);
            }
        }
    }

    public void addClause(int[] lits) {
        this.listclause.add(new WLClause(lits, this.voc));
    }

    public static IntDomainVar[] removeRedundantVars(IntDomainVar[] vs) {
        HashSet<IntDomainVar> filteredVars = new HashSet<IntDomainVar>(12);
        for (int i = 0; i < vs.length; ++i) {
            if (filteredVars.contains(vs[i])) continue;
            filteredVars.add(vs[i]);
        }
        IntDomainVar[] filteredTab = new IntDomainVar[filteredVars.size()];
        filteredVars.toArray(filteredTab);
        return filteredTab;
    }

    public int[] computeLits(IntDomainVar[] plit, IntDomainVar[] nlit) {
        int lit;
        int[] lits = new int[plit.length + nlit.length];
        int cpt = 0;
        for (IntDomainVar aPlit : plit) {
            lits[cpt] = lit = this.findIndex(aPlit);
            ++cpt;
        }
        for (IntDomainVar aNlit : nlit) {
            lit = this.findIndex(aNlit);
            lits[cpt] = -lit;
            ++cpt;
        }
        return lits;
    }

    public void updateDegree(int[] lit) {
        for (int i = 0; i < lit.length; ++i) {
            int l;
            int n = l = lit[i] < 0 ? -lit[i] - 1 : lit[i] - 1;
            this.fineDegree[n] = this.fineDegree[n] + 1;
        }
    }

    public void addClause(IntDomainVar[] positivelits, IntDomainVar[] negativelits) {
        IntDomainVar[] plit = ClauseStore.removeRedundantVars(positivelits);
        IntDomainVar[] nlit = ClauseStore.removeRedundantVars(negativelits);
        int[] lits = this.computeLits(plit, nlit);
        this.updateDegree(lits);
        if (lits.length == 1) {
            if (plit.length == 1) {
                this.instToOne.add(((IntDomainVar[])this.vars)[lits[0] - 1]);
            } else {
                this.instToZero.add(((IntDomainVar[])this.vars)[-lits[0] - 1]);
            }
        } else {
            WLClause cl = lits.length == 2 ? new BinaryWLClause(lits, this.voc) : new WLClause(lits, this.voc);
            cl.setIdx(this.listclause.size());
            this.listclause.add(cl);
            if (lits.length > 2) {
                ++this.nbNonBinaryClauses;
            }
        }
    }

    public int findIndex(IntDomainVar v) {
        return this.indexes.get(v.getIndex()) + 1;
    }

    public void addNoGood(IntDomainVar[] positivelits, IntDomainVar[] negativelits) {
        IntDomainVar[] plit = ClauseStore.removeRedundantVars(positivelits);
        IntDomainVar[] nlit = ClauseStore.removeRedundantVars(negativelits);
        int[] lits = this.computeLits(plit, nlit);
        this.updateDegree(lits);
        if (lits.length == 1) {
            if (plit.length == 1) {
                this.instToOne.add(((IntDomainVar[])this.vars)[lits[0] - 1]);
            } else {
                this.instToZero.add(((IntDomainVar[])this.vars)[-lits[0] - 1]);
            }
        } else {
            DynWLClause clause = new DynWLClause(lits, this.voc);
            clause.setIdx(this.listclause.size());
            this.listclause.add(clause);
            this.listToPropagate.addLast(clause);
            if (lits.length > 2) {
                ++this.nbNonBinaryClauses;
            }
        }
    }

    public DynWLClause fast_addNoGood(int[] lits) {
        this.updateDegree(lits);
        if (lits.length == 1) {
            if (lits[0] > 0) {
                this.instToOne.add(((IntDomainVar[])this.vars)[lits[0] - 1]);
            } else {
                this.instToZero.add(((IntDomainVar[])this.vars)[-lits[0] - 1]);
            }
            return null;
        }
        DynWLClause clause = new DynWLClause(lits, this.voc);
        clause.setIdx(this.listclause.size());
        this.listclause.add(clause);
        this.listToPropagate.addLast(clause);
        if (lits.length > 2) {
            ++this.nbNonBinaryClauses;
        }
        return clause;
    }

    public void delete(WLClause wlc) {
        if (wlc.getIdx() != this.listclause.size() - 1) {
            WLClause lastclause = this.listclause.remove(this.listclause.size() - 1);
            this.listclause.set(wlc.getIdx(), lastclause);
            lastclause.setIdx(wlc.getIdx());
        } else {
            this.listclause.remove(this.listclause.size() - 1);
        }
        if (wlc.getLits().length > 2) {
            --this.nbNonBinaryClauses;
        }
        this.listToPropagate.remove(wlc);
        wlc.unregister();
    }

    public void createEntailmentStructures() {
        int[] lclauses = new int[this.listclause.size()];
        for (int i = 0; i < lclauses.length; ++i) {
            lclauses[i] = i;
        }
        this.clauses_not_entailed = this.environment.makeBipartiteSet(lclauses);
    }

    public void initEntailmentStructures() {
        int[][] count = new int[((IntDomainVar[])this.vars).length][2];
        for (WLClause cl : this.listclause) {
            int[] lits = cl.lits;
            for (int i = 0; i < lits.length; ++i) {
                int lit = lits[i];
                if (lit > 0) {
                    int[] nArray = count[lit - 1];
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                int[] nArray = count[-lit - 1];
                nArray[0] = nArray[0] + 1;
            }
        }
        int idxcl = 0;
        this.clause_entailed = new int[((IntDomainVar[])this.vars).length][2][];
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            this.clause_entailed[i][0] = new int[count[i][0]];
            this.clause_entailed[i][1] = new int[count[i][1]];
        }
        count = new int[((IntDomainVar[])this.vars).length][2];
        for (WLClause cl : this.listclause) {
            int[] lits = cl.lits;
            for (int i = 0; i < lits.length; ++i) {
                int lit = lits[i];
                if (lit > 0) {
                    this.clause_entailed[lit - 1][1][count[lit - 1][1]] = idxcl;
                    int[] nArray = count[lit - 1];
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                this.clause_entailed[-lit - 1][0][count[-lit - 1][0]] = idxcl;
                int[] nArray = count[-lit - 1];
                nArray[0] = nArray[0] + 1;
            }
            ++idxcl;
        }
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.efficient_entailment_test) {
            this.createEntailmentStructures();
            this.initEntailmentStructures();
        }
        for (WLClause cl : this.listclause) {
            if (cl.isRegistered()) continue;
            cl.register(this);
        }
        this.propagate();
    }

    public void propagateUnitClause() throws ContradictionException {
        for (IntDomainVar v : this.instToOne) {
            v.instantiate(1, null, true);
        }
        for (IntDomainVar v : this.instToZero) {
            v.instantiate(0, null, true);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        Iterator iterator = this.listToPropagate.iterator();
        while (iterator.hasNext()) {
            WLClause cl = (WLClause)iterator.next();
            if (!cl.register(this)) continue;
            iterator.remove();
        }
        if (this.efficient_entailment_test) {
            for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
                if (!((IntDomainVar[])this.vars)[i].isInstantiated()) continue;
                this.maintainEfficientEntailment(i, ((IntDomainVar[])this.vars)[i].getVal());
            }
        }
        this.propagateUnitClause();
    }

    public void filterFromScratch() throws ContradictionException {
        for (WLClause cl : this.listclause) {
            cl.simplePropagation(this);
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.efficient_entailment_test) {
            if (this.clauses_not_entailed.isEmpty()) {
                return Boolean.TRUE;
            }
            return null;
        }
        boolean unknownflag = false;
        for (WLClause cl : this.listclause) {
            Boolean b = cl.isEntailed();
            if (b != null) {
                if (b.booleanValue()) continue;
                return Boolean.FALSE;
            }
            unknownflag = true;
        }
        if (unknownflag) {
            return null;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean isSatisfied() {
        for (WLClause cl : this.listclause) {
            if (cl.isNogood() || cl.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (WLClause cl : this.listclause) {
            if (cl.isNogood()) continue;
            int[] lit = cl.getLits();
            int[] clt = new int[lit.length];
            for (int i = 0; i < lit.length; ++i) {
                clt[i] = tuple[Math.abs(lit[i]) - 1];
            }
            if (cl.isSatisfied(clt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFineDegree(int idx) {
        return this.fineDegree[idx];
    }

    public int getNbEntailedClauseFrom(int idx, int val) {
        int nbentailedclause = 0;
        for (int i = 0; i < this.clause_entailed[idx][val].length; ++i) {
            if (!this.clauses_not_entailed.contain(this.clause_entailed[idx][val][i])) continue;
            ++nbentailedclause;
        }
        return nbentailedclause;
    }

    public int getNbClause() {
        return this.listclause.size();
    }

    public final void printClauses() {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder b = new StringBuilder(32);
            for (WLClause wlClause : this.listclause) {
                b.append(wlClause);
            }
            LOGGER.info(new String(b));
        }
    }
}

