/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb;

import choco.cp.solver.constraints.integer.intlincomb.policy.CoeffPolicy;
import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class IntLinCombOp {
    final int[] coeffs;
    private final int nbPosVars;
    final int cste;
    final IntDomainVar[] vars;
    private final AbstractSConstraint constraint;
    final CoeffPolicy coeffPolicy;

    IntLinCombOp(int[] coeffs, int nbPosVars, int cste, IntDomainVar[] vars, AbstractSConstraint constraint) {
        this.coeffs = coeffs;
        this.nbPosVars = nbPosVars;
        this.cste = cste;
        this.vars = vars;
        this.constraint = constraint;
        this.coeffPolicy = CoeffPolicy.build(vars, coeffs, nbPosVars, cste);
    }

    public abstract Boolean isEntailed();

    public abstract boolean isSatisfied(int[] var1);

    public final int compute(int[] tuple) {
        int s = this.cste;
        int nbVars = this.vars.length;
        for (int i = 0; i < nbVars; ++i) {
            s += tuple[i] * this.coeffs[i];
        }
        return s;
    }

    protected abstract boolean filterOnImprovedLowerBound() throws ContradictionException;

    protected abstract boolean filterOnImprovedUpperBound() throws ContradictionException;

    public abstract boolean isConsistent();

    public abstract AbstractSConstraint opposite(Solver var1);

    public final void filter(boolean startWithLB, int minNbRules) throws ContradictionException {
        boolean lastRuleEffective = true;
        boolean nextRuleIsLB = startWithLB;
        for (int nbr = 0; lastRuleEffective || nbr < minNbRules; ++nbr) {
            lastRuleEffective = nextRuleIsLB ? this.filterOnImprovedLowerBound() : this.filterOnImprovedUpperBound();
            nextRuleIsLB ^= true;
        }
    }

    final boolean propagateNewLowerBound(int mylb) throws ContradictionException {
        int i;
        boolean anyChange = false;
        int nbVars = this.vars.length;
        if (mylb > 0) {
            this.constraint.fail();
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newSupi = this.coeffPolicy.getSupPV(i, mylb);
            if (!this.vars[i].updateSup(newSupi, this.constraint, false)) continue;
            anyChange = true;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newInfi = this.coeffPolicy.getInfNV(i, mylb);
            if (!this.vars[i].updateInf(newInfi, this.constraint, false)) continue;
            anyChange = true;
        }
        return anyChange;
    }

    final boolean propagateNewUpperBound(int myub) throws ContradictionException {
        int i;
        boolean anyChange = false;
        int nbVars = this.vars.length;
        if (myub < 0) {
            this.constraint.fail();
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newInfi = this.coeffPolicy.getInfPV(i, myub);
            if (!this.vars[i].updateInf(newInfi, this.constraint, false)) continue;
            anyChange = true;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newSupi = this.coeffPolicy.getSupNV(i, myub);
            if (!this.vars[i].updateSup(newSupi, this.constraint, false)) continue;
            anyChange = true;
        }
        return anyChange;
    }

    final boolean hasConsistentLowerBound() {
        int i;
        int lb = this.coeffPolicy.computeLowerBound();
        int nbVars = this.vars.length;
        if (lb > 0) {
            return false;
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newSupi = MathUtils.divFloor(-lb, this.coeffs[i]) + this.vars[i].getInf();
            if (this.vars[i].getSup() >= newSupi) continue;
            return false;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newInfi = MathUtils.divCeil(lb, -this.coeffs[i]) + this.vars[i].getSup();
            if (this.vars[i].getInf() <= newInfi) continue;
            return false;
        }
        return true;
    }

    protected final boolean hasConsistentUpperBound() {
        int i;
        int ub = this.coeffPolicy.computeUpperBound();
        int nbVars = this.vars.length;
        if (ub < 0) {
            return false;
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newInfi = MathUtils.divCeil(-ub, this.coeffs[i]) + this.vars[i].getSup();
            if (this.vars[i].getInf() <= newInfi) continue;
            return false;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newSupi = MathUtils.divFloor(ub, -this.coeffs[i]) + this.vars[i].getInf();
            if (this.vars[i].getSup() >= newSupi) continue;
            return false;
        }
        return true;
    }

    protected abstract String getOperator();

    public String pretty() {
        StringBuilder linComb = new StringBuilder(16);
        for (int i = 0; i < this.coeffs.length - 1; ++i) {
            linComb.append(this.coeffs[i]).append('*').append(this.vars[i]).append(" + ");
        }
        linComb.append(this.coeffs[this.coeffs.length - 1]).append('*').append(this.vars[this.coeffs.length - 1]);
        linComb.append(this.getOperator());
        linComb.append(-this.cste);
        return linComb.toString();
    }
}

