/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.real.AbstractBinRealIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealVar;

public final class MixedCstElt
extends AbstractBinRealIntSConstraint {
    protected double[] values;

    public MixedCstElt(RealVar v0, IntDomainVar v1, double[] values) {
        super(v0, v1);
        this.values = values;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MixedCstElt newc = (MixedCstElt)super.clone();
        newc.values = new double[this.values.length];
        System.arraycopy(this.values, 0, newc.values, 0, this.values.length);
        return newc;
    }

    @Override
    public void awake() throws ContradictionException {
        this.v1.updateSup(this.values.length - 1, this, false);
        this.v1.updateInf(0, this, false);
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.updateIInf();
        this.updateISup();
        this.updateReal();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateIInf();
            this.updateReal();
        } else {
            this.updateReal();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateISup();
            this.updateReal();
        } else {
            this.updateReal();
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateIInf();
            this.updateISup();
            this.updateReal();
        } else {
            this.updateReal();
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.awakeOnBounds(varIdx);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int varIdx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    public void updateIInf() throws ContradictionException {
        int inf = this.v1.getInf();
        while (this.values[inf] < this.v0.getInf()) {
            ++inf;
        }
        if (inf > this.v1.getSup()) {
            this.propagationEngine.raiseContradiction(this);
        }
        this.v1.updateInf(inf, this, false);
    }

    public void updateISup() throws ContradictionException {
        int sup = this.v1.getSup();
        while (this.values[sup] > this.v0.getSup()) {
            --sup;
        }
        if (sup < this.v1.getInf()) {
            this.propagationEngine.raiseContradiction(this);
        }
        this.v1.updateSup(sup, this, false);
    }

    public void updateReal() throws ContradictionException {
        this.v0.intersect(new RealIntervalConstant(this.values[this.v1.getInf()], this.values[this.v1.getSup()]));
    }

    @Override
    public boolean isConsistent() {
        return this.values[this.v1.getInf()] <= this.v0.getSup() && this.v0.getInf() <= this.values[this.v1.getSup()];
    }

    @Override
    public boolean isSatisfied() {
        return this.isConsistent();
    }
}

