/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.scheduling;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.propagation.listener.TaskPropagator;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public abstract class AbstractTaskSConstraint
extends AbstractLargeIntSConstraint
implements TaskPropagator {
    protected final TaskVar[] taskvars;
    protected final int startOffset;
    protected final int endOffset;
    protected final int taskIntVarOffset;

    public AbstractTaskSConstraint(TaskVar task1, TaskVar task2, IntDomainVar ... otherVars) {
        this(new TaskVar[]{task1, task2}, otherVars, new IntDomainVar[0]);
    }

    public AbstractTaskSConstraint(TaskVar[] taskvars, IntDomainVar[] intvars, IntDomainVar ... otherVars) {
        super(ConstraintEvent.LINEAR, AbstractTaskSConstraint.makeIntVarArray(taskvars, intvars, otherVars));
        this.taskvars = taskvars;
        this.startOffset = this.getNbTasks();
        this.endOffset = 2 * this.startOffset;
        this.taskIntVarOffset = 3 * this.startOffset;
    }

    public static final TaskVar[] createTaskVarArray(Solver solver) {
        int n = solver.getNbTaskVars();
        TaskVar[] tasks = new TaskVar[n];
        for (int i = 0; i < n; ++i) {
            tasks[i] = solver.getTaskVar(i);
            if (tasks[i].getID() == i) continue;
            throw new SolverException("invalid task ID");
        }
        return tasks;
    }

    public static final IntDomainVar[] makeIntVarArray(TaskVar[] taskvars, IntDomainVar[] intvars, IntDomainVar[] othervars) {
        int i;
        int n = taskvars.length;
        int v1 = 2 * n;
        int v2 = 3 * n;
        int v3 = v2 + (intvars == null ? 0 : intvars.length);
        int v4 = v3 + (othervars == null ? 0 : othervars.length);
        IntDomainVar[] ivars = new IntDomainVar[v4];
        for (i = 0; i < n; ++i) {
            ivars[i] = taskvars[i].start();
            ivars[i + n] = taskvars[i].end();
            ivars[i + v1] = taskvars[i].duration();
        }
        for (i = v2; i < v3; ++i) {
            ivars[i] = intvars[i - v2];
        }
        for (i = v3; i < v4; ++i) {
            ivars[i] = othervars[i - v3];
        }
        return ivars;
    }

    protected final int getTaskIntVarOffset() {
        return this.taskIntVarOffset;
    }

    protected final int getStartIndex(int tidx) {
        return tidx;
    }

    protected final int getEndIndex(int tidx) {
        return this.startOffset + tidx;
    }

    protected final int getDurationIndex(int tidx) {
        return this.endOffset + tidx;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        super.addListener(dynamicAddition);
        for (int i = 0; i < this.getNbTasks(); ++i) {
            this.getTask(i).addConstraint(this, -1, dynamicAddition);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
    }

    public final int getNbTasks() {
        return this.taskvars.length;
    }

    public final TaskVar getTask(int idx) {
        return this.taskvars[idx];
    }

    protected final String pretty(String name) {
        StringBuilder b = new StringBuilder();
        b.append(name).append("( ");
        b.append(StringUtils.pretty((IPretty[])this.taskvars));
        if (((IntDomainVar[])this.vars).length > this.taskIntVarOffset) {
            b.append(", ");
            b.append(StringUtils.pretty((IPretty[])this.vars, this.taskIntVarOffset, ((IntDomainVar[])this.vars).length));
        }
        b.append(" )");
        return new String(b);
    }

    @Override
    public String pretty() {
        return this.pretty(this.getClass().getSimpleName());
    }

    public boolean isTaskConsistencyEnforced() {
        return false;
    }

    @Override
    public void awakeOnHypDomMod(int varIdx) throws ContradictionException {
    }
}

