# Landing page
helppage <- tabItem(
  tabName = "help",
  h1(
    tags$code("presize"),
    " : precision based sample size calculation"
  ),
  "It is sometimes desirable to power a study on the precision of an estimate rather than for a particular hypothesis test.",
  tags$code("presize"),
  "provides a range of functions for performing these calculations. ",
  tags$code("presize"),
  "returns either the confidence interval width that could be expected given a sample size, or the sample size that would be necessary to attain a given confidence interval width.",
  tags$br(),
  "For instance, it may be that we want to estimate the mean amount of a blood parameter to within 5 units. Based on published literature, we expect the mean value to be 20 units, with a standard deviation of 3. To achieve the 5 unit confidence interval width,",
  textOutput("ex_n", inline = TRUE),
  "participants are required. If we know that we have funding to include 50 participants, we can calculate the confidence interval width that we could expect, and find that it would be",
  textOutput("ex_ciw", inline = TRUE),
  "units wide.",
  tags$br(),
  tags$br(),
  "The different estimators are grouped according to their type (e.g. mean and proportion are under 'Descriptive statistics', while odds and risk ratios are under 'Relative differences'.",
  tags$br(),
  tags$br(),
  "Each statistic has a set of fields. Mandatory fields are marked with an asterisk (*). There are also two fields that pertain to the sample size and confidence interval width, indicated by a dagger (†). Only one of these should be entered.",
  tags$br(),
  tags$br(),
  "Relevant references are listed on each page.",
  tags$br(),
  tags$br(),
  "This site uses the ",
  tags$code("presize"),
  " R package",
  " (version", textOutput("version", inline = TRUE),
  "), which was developed at CTU Bern, the Clinical Trials Unit of the University of Bern and University Hospital Bern, on behalf of the Statistics & Methodology Platform of the ",
  tags$a(href = "https://www.scto.ch/de/network/scto-platforms/statistics-and-methodology.html", "Swiss Clinical Trial Organisation"),
  ". The R package version of ",
  tags$code("presize"),
  " can be installed in R using the from CRAN (",
  tags$code("install.packages('presize')"),
  "). The R code for running the calculations in this site is shown after the results. The",
  tags$code("presize"),
  "package website can be found ",
  tags$a(href = "https://ctu-bern.github.io/presize/", "here"),
  ".",
  tags$br(),
  "If you use ", tags$code("presize"), ", please cite it in your publication as: Haynes et al., (2021). presize: An R-package for precision-based sample size calculation in clinical research. Journal of Open Source Software, 6(60), 3118, ",
  tags$a(href = "https://doi.org/10.21105/joss.03118", "DOI 10.21105/joss.03118")

)
