/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.MultiLabel;
import org.jpmml.converter.OrdinalLabel;
import org.jpmml.converter.ScalarLabel;

public class ScalarLabelUtil {
    private ScalarLabelUtil() {
    }

    public static ScalarLabel createScalarLabel(DataField dataField) {
        DataType dataType = dataField.requireDataType();
        OpType opType = dataField.requireOpType();
        switch (opType) {
            case CONTINUOUS: {
                return new ContinuousLabel((Field<?>)dataField);
            }
            case CATEGORICAL: {
                return new CategoricalLabel(dataField);
            }
            case ORDINAL: {
                return new OrdinalLabel(dataField);
            }
        }
        throw new IllegalArgumentException();
    }

    public static List<ScalarLabel> toScalarLabels(Label label) {
        return ScalarLabelUtil.toScalarLabels(ScalarLabel.class, label);
    }

    public static <E extends ScalarLabel> List<E> toScalarLabels(Class<? extends E> clazz, Label label) {
        if (label instanceof ScalarLabel) {
            ScalarLabel scalarLabel = (ScalarLabel)label;
            return Collections.singletonList(clazz.cast(scalarLabel));
        }
        if (label instanceof MultiLabel) {
            MultiLabel multiLabel = (MultiLabel)label;
            List<? extends Label> labels = multiLabel.getLabels();
            return labels.stream().map(clazz::cast).collect(Collectors.toList());
        }
        throw new IllegalArgumentException();
    }
}

