/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import org.dmg.pmml.HasScoreDistributions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.ScoreFrequency;
import org.dmg.pmml.ScoreProbability;
import org.jpmml.model.PMMLObjectCache;

public class ScoreDistributionManager {
    private PMMLObjectCache<ScoreDistribution> cache = new PMMLObjectCache();

    public <E extends PMMLObject> void addScoreDistributions(E object, List<?> values, List<? extends Number> recordCounts, List<? extends Number> probabilities) {
        List scoreDistributions = ((HasScoreDistributions)object).getScoreDistributions();
        for (int i = 0; i < values.size(); ++i) {
            ScoreDistribution scoreDistribution;
            Number recordCount;
            Object value = values.get(i);
            Number number = recordCount = recordCounts != null ? (Number)recordCounts.get(i) : (Number)null;
            if (probabilities != null) {
                Number probability = probabilities.get(i);
                scoreDistribution = this.createScoreProbability(value, recordCount, probability);
            } else {
                scoreDistribution = this.createScoreFrequency(value, recordCount);
            }
            scoreDistributions.add(scoreDistribution);
        }
    }

    public ScoreDistribution createScoreFrequency(Object value, Number recordCount) {
        ScoreFrequency scoreDistribution = new ScoreFrequency(value, recordCount);
        return this.intern((ScoreDistribution)scoreDistribution);
    }

    public ScoreDistribution createScoreProbability(Object value, Number recordCount, Number probability) {
        ScoreProbability scoreDistribution = new ScoreProbability(value, recordCount, probability);
        return this.intern((ScoreDistribution)scoreDistribution);
    }

    public ScoreDistribution intern(ScoreDistribution scoreDistribution) {
        return (ScoreDistribution)this.cache.intern((PMMLObject)scoreDistribution);
    }

    public static <E extends Comparable<E>> int indexOfMax(List<E> values) {
        int result = -1;
        Comparable maxValue = null;
        for (int i = 0; i < values.size(); ++i) {
            Comparable value = (Comparable)values.get(i);
            if (maxValue != null && value.compareTo(maxValue) <= 0) continue;
            result = i;
            maxValue = value;
        }
        return result;
    }
}

