% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R, R/use.R
\name{embed}
\alias{embed}
\alias{use}
\title{Capture and re-use dependencies within a \code{.R}, \code{.Rmd} or \code{.qmd}}
\usage{
embed(path = NULL, ..., lockfile = NULL, project = NULL)

use(
  ...,
  lockfile = NULL,
  library = NULL,
  isolate = TRUE,
  sandbox = TRUE,
  attach = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{The path to an \R or R Markdown script. The default will use the current
document, if running within RStudio.}

\item{...}{The \R packages to be used with this script. Ignored if \code{lockfile} is
non-\code{NULL}.}

\item{lockfile}{The lockfile to use. When supplied, renv will use the packages as
declared in the lockfile.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{library}{The library path into which the requested packages should be installed.
When \code{NULL} (the default), a library path within the \R temporary
directory will be generated and used. Note that this same library path
will be re-used on future calls to \code{renv::use()}, allowing \code{renv::use()}
to be used multiple times within a single script.}

\item{isolate}{Boolean; should the active library paths be included in the set of library
paths activated for this script? Set this to \code{TRUE} if you only want the
packages provided to \code{renv::use()} to be visible on the library paths.}

\item{sandbox}{Should the system library be sandboxed? See the sandbox documentation in
\link{config} for more details. You can also provide an explicit sandbox
path if you want to configure where \code{renv::use()} generates its sandbox.
By default, the sandbox is generated within the \R temporary directory.}

\item{attach}{Boolean; should the set of requested packages be automatically attached?
If \code{TRUE}, packages will be loaded and attached via a call
to \code{\link[=library]{library()}} after install. Ignored if \code{lockfile} is non-\code{NULL}.}

\item{verbose}{Boolean; be verbose while installing packages?}
}
\value{
This function is normally called for its side effects.
}
\description{
Together, \code{embed()} and \code{use()} provide a lightweight way to specify and
restore package versions within a file. \code{use()} is a lightweight lockfile
specification that \code{embed()} can automatically generate and insert into a
script or document.

Calling \code{embed()} inspects the dependencies of the specified document then
generates and inserts a call to \code{use()} that looks something like this:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{renv::use(
  "digest@0.6.30",
  "rlang@0.3.4"
)
}\if{html}{\out{</div>}}

Then, when you next run your R script or render your \code{.Rmd} or \code{.qmd}, \code{use()} will:
\enumerate{
\item Create a temporary library path.
\item Install the requested packages and their recursive dependencies into that
library.
\item Activate the library, so it's used for the rest of the script.
}
\subsection{Manual usage}{

You can also create calls to \code{use()} yourself, either specifying the
packages needed by hand, or by supplying the path to a lockfile,
\code{renv::use(lockfile = "/path/to/renv.lock")}.

This can be useful in projects where you'd like to associate different
lockfiles with different documents, as in a blog where you want each
post to capture the dependencies at the time of writing. Once you've
finished writing each, the post, you can use
\code{renv::snapshot(lockfile = "/path/to/renv.lock")}
to "save" the state that was active while authoring that bost, and then use
\code{renv::use(lockfile = "/path/to/renv.lock")} in that document to ensure the
blog post always uses those dependencies onfuture renders.

\code{renv::use()} is inspired in part by the \href{https://groundhogr.com/}{groundhog}
package, which also allows one to specify a script's \R package requirements
within that same \R script.
}
}
