/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.hybrid;

import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.hybrid.ASupport;
import org.chocosolver.solver.constraints.extension.hybrid.HybridTuples;
import org.chocosolver.solver.constraints.extension.hybrid.ISupportable;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

@Explained(ignored=true, comment="Turned into clauses")
public class PropHybridTable
extends Propagator<IntVar> {
    private final ISupportable[][] table;
    private final ASupport.StrHVar[] str2vars;
    private final ISet activeTuples;
    private final BitSet ssup;
    private final BitSet sval;
    private final UndirectedGraph relationships;
    private boolean firstProp = true;

    public PropHybridTable(IntVar[] vars, HybridTuples tuples) {
        super((Variable[])vars, (Priority)PropagatorPriority.QUADRATIC, false);
        this.table = tuples.toArray();
        int nbVars = vars.length;
        this.relationships = new UndirectedGraph(nbVars, SetType.BITSET, SetType.BITSET, true);
        this.str2vars = new ASupport.StrHVar[nbVars];
        for (int i = 0; i < nbVars; ++i) {
            this.str2vars[i] = new ASupport.StrHVar(this.model.getEnvironment(), vars[i], i);
            for (int t = 0; t < this.table.length; ++t) {
                this.connect(this.table[t][i]);
            }
        }
        this.activeTuples = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.ssup = new BitSet(vars.length);
        this.sval = new BitSet(vars.length);
    }

    private void connect(ISupportable supportable) {
        block4: {
            block3: {
                if (!(supportable instanceof ISupportable.Many)) break block3;
                ISupportable.Many many = (ISupportable.Many)supportable;
                for (ISupportable supp : many.exps) {
                    this.connect(supp);
                }
                break block4;
            }
            if (!(supportable instanceof ISupportable.Nary)) break block4;
            ISupportable.Nary nary = (ISupportable.Nary)supportable;
            for (int i = 0; i < nary.is.length - 1; ++i) {
                for (int j = i + 1; j < nary.is.length; ++j) {
                    this.relationships.addEdge(nary.is[i], nary.is[j]);
                }
            }
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.firstProp) {
            this.firstProp = false;
            this.model.getEnvironment().save(() -> {
                this.firstProp = true;
            });
            this.initialPropagate();
        }
        this.filter();
    }

    @Override
    public ESat isEntailed() {
        boolean hasSupport = false;
        block0: for (int i = 0; i < this.table.length && !hasSupport; ++i) {
            for (int j = 0; j < this.str2vars.length; ++j) {
                ASupport.StrHVar v = this.str2vars[j];
                if (!this.table[i][v.index].satisfiable(this.str2vars, v.index)) continue block0;
            }
            hasSupport = true;
        }
        if (hasSupport) {
            if (this.isCompletelyInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "STR2 hybrid table constraint with " + ((IntVar[])this.vars).length + " vars and " + this.table.length + " tuples";
    }

    private boolean isTupleSupported(int tuple_index) {
        int i = this.sval.nextSetBit(0);
        while (i > -1) {
            ASupport.StrHVar v = this.str2vars[i];
            if (!this.table[tuple_index][v.index].satisfiable(this.str2vars, v.index)) {
                return false;
            }
            i = this.sval.nextSetBit(i + 1);
        }
        return true;
    }

    private void initialPropagate() throws ContradictionException {
        for (int t = 0; t < this.table.length; ++t) {
            this.activeTuples.add(t);
        }
        if (this.activeTuples.isEmpty()) {
            this.fails();
        }
    }

    private void filter() throws ContradictionException {
        boolean loop;
        int n;
        this.ssup.clear();
        this.sval.clear();
        for (int i = 0; i < this.str2vars.length; ++i) {
            ASupport.StrHVar tmp = this.str2vars[i];
            this.ssup.set(i);
            tmp.reset();
            if (tmp.last_size.get() == tmp.cnt) continue;
            this.sval.set(i);
            tmp.last_size.set(tmp.cnt);
            ISetIterator iSetIterator = this.relationships.getNeighborsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                n = (Integer)iSetIterator.next();
                this.sval.set(n);
            }
        }
        do {
            loop = false;
            ISetIterator tmp = this.activeTuples.iterator();
            while (tmp.hasNext()) {
                int tidx = (Integer)tmp.next();
                if (this.isTupleSupported(tidx)) {
                    int i = this.ssup.nextSetBit(0);
                    while (i > -1) {
                        ISupportable exp = this.table[tidx][i];
                        if (!this.sval.get(i) && exp instanceof ISupportable.Many) {
                            exp.satisfiable(this.str2vars, i);
                        }
                        exp.support(this.str2vars, i);
                        if (this.str2vars[i].cnt == 0) {
                            this.ssup.clear(i);
                        }
                        i = this.ssup.nextSetBit(i + 1);
                    }
                    continue;
                }
                this.activeTuples.remove(tidx);
            }
            this.sval.clear();
            for (int i = 0; i < this.str2vars.length; ++i) {
                if (this.str2vars[i].cnt > 0 && this.str2vars[i].removeUnsupportedValue(this)) {
                    loop = true;
                    this.sval.set(i);
                    ISetIterator iSetIterator = this.relationships.getNeighborsOf(i).iterator();
                    while (iSetIterator.hasNext()) {
                        n = (Integer)iSetIterator.next();
                        this.sval.set(n);
                    }
                    this.str2vars[i].last_size.set(this.str2vars[i].cnt);
                }
                this.ssup.set(i);
            }
        } while (loop);
    }
}

